/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Optional;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.mixin.accessors.effect.AccessorMobEffectInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class SerializerEffectInstance
implements ISerializer<MobEffectInstance> {
    @Override
    public MobEffectInstance fromJSON(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            MobEffect effect = Serializers.MOB_EFFECT.fromJSON(obj, "effect");
            int duration = Serializers.INT.fromJSON(obj, "duration");
            int amplifier = Serializers.INT.fromJSON(obj, "amplifier", 0);
            boolean ambient = Serializers.BOOLEAN.fromJSON(obj, "ambient", false);
            boolean visible = Serializers.BOOLEAN.fromJSON(obj, "visible", true);
            boolean showIcon = Serializers.BOOLEAN.fromJSON(obj, "showIcon", true);
            MobEffectInstance hiddenEffect = Serializers.EFFECT_INSTANCE.fromJSON(obj, "hiddenEffect", (MobEffectInstance)null);
            return new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon, hiddenEffect, effect.m_216881_());
        }
        throw new JsonParseException("Expected JSON object.");
    }

    @Override
    public JsonElement toJSON(MobEffectInstance toWrite) {
        JsonObject json = new JsonObject();
        Serializers.MOB_EFFECT.toJSON(json, "effect", toWrite.m_19544_());
        Serializers.INT.toJSON(json, "duration", toWrite.m_19557_());
        if (toWrite.m_19564_() != 0) {
            Serializers.INT.toJSON(json, "amplifier", toWrite.m_19564_());
        }
        if (toWrite.m_19571_()) {
            Serializers.BOOLEAN.toJSON(json, "ambient", toWrite.m_19571_());
        }
        if (!toWrite.m_19572_()) {
            Serializers.BOOLEAN.toJSON(json, "visible", toWrite.m_19572_());
        }
        if (!toWrite.m_19575_()) {
            Serializers.BOOLEAN.toJSON(json, "showIcon", toWrite.m_19575_());
        }
        if (((AccessorMobEffectInstance)toWrite).bookshelf$getHiddenEffect() != null) {
            Serializers.EFFECT_INSTANCE.toJSON(json, "hiddenEffect", ((AccessorMobEffectInstance)toWrite).bookshelf$getHiddenEffect());
        }
        return json;
    }

    @Override
    public MobEffectInstance fromByteBuf(FriendlyByteBuf buffer) {
        MobEffect effect = Serializers.MOB_EFFECT.fromByteBuf(buffer);
        int duration = Serializers.INT.fromByteBuf(buffer);
        int amplifier = Serializers.INT.fromByteBuf(buffer);
        boolean ambient = Serializers.BOOLEAN.fromByteBuf(buffer);
        boolean visible = Serializers.BOOLEAN.fromByteBuf(buffer);
        boolean showIcon = Serializers.BOOLEAN.fromByteBuf(buffer);
        MobEffectInstance hiddenEffect = Serializers.EFFECT_INSTANCE.fromByteBufOptional(buffer).orElse(null);
        return new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon, hiddenEffect, effect.m_216881_());
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, MobEffectInstance toWrite) {
        Serializers.MOB_EFFECT.toByteBuf(buffer, toWrite.m_19544_());
        Serializers.INT.toByteBuf(buffer, toWrite.m_19557_());
        Serializers.INT.toByteBuf(buffer, toWrite.m_19564_());
        Serializers.BOOLEAN.toByteBuf(buffer, toWrite.m_19571_());
        Serializers.BOOLEAN.toByteBuf(buffer, toWrite.m_19572_());
        Serializers.BOOLEAN.toByteBuf(buffer, toWrite.m_19575_());
        Serializers.EFFECT_INSTANCE.toByteBufOptional(buffer, Optional.ofNullable(((AccessorMobEffectInstance)toWrite).bookshelf$getHiddenEffect()));
    }

    @Override
    public Tag toNBT(MobEffectInstance toWrite) {
        CompoundTag tag = new CompoundTag();
        Serializers.MOB_EFFECT.toNBT(tag, "effect", toWrite.m_19544_());
        Serializers.INT.toNBT(tag, "duration", toWrite.m_19557_());
        if (toWrite.m_19564_() != 0) {
            Serializers.INT.toNBT(tag, "amplifier", toWrite.m_19564_());
        }
        if (toWrite.m_19571_()) {
            Serializers.BOOLEAN.toNBT(tag, "ambient", toWrite.m_19571_());
        }
        if (!toWrite.m_19572_()) {
            Serializers.BOOLEAN.toNBT(tag, "visible", toWrite.m_19572_());
        }
        if (!toWrite.m_19575_()) {
            Serializers.BOOLEAN.toNBT(tag, "showIcon", toWrite.m_19575_());
        }
        if (((AccessorMobEffectInstance)toWrite).bookshelf$getHiddenEffect() != null) {
            Serializers.EFFECT_INSTANCE.toNBT(tag, "hiddenEffect", ((AccessorMobEffectInstance)toWrite).bookshelf$getHiddenEffect());
        }
        return tag;
    }

    @Override
    public MobEffectInstance fromNBT(Tag nbt) {
        CompoundTag tag = Serializers.COMPOUND_TAG.fromNBT(nbt);
        MobEffect effect = Serializers.MOB_EFFECT.fromNBT(tag, "effect");
        int duration = Serializers.INT.fromNBT(tag, "duration");
        int amplifier = Serializers.INT.fromNBT(tag, "amplifier", 0);
        boolean ambient = Serializers.BOOLEAN.fromNBT(tag, "ambient", false);
        boolean visible = Serializers.BOOLEAN.fromNBT(tag, "visible", true);
        boolean showIcon = Serializers.BOOLEAN.fromNBT(tag, "showIcon", true);
        MobEffectInstance hiddenEffect = Serializers.EFFECT_INSTANCE.fromNBT(tag, "hiddenEffect", null);
        return new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon, hiddenEffect, effect.m_216881_());
    }
}

