/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.lib;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class TableBuilder<T> {
    private static final String NEW_LINE = System.lineSeparator();
    private static final String DIVIDER_COLUMN = "|";
    private static final String DIVIDER_ROW = "-";
    private final List<TableColumn<T>> columns = new LinkedList<TableColumn<T>>();
    private int entryCount = 0;

    public TableBuilder<T> addColumn(String name, Function<T, Object> function) {
        this.columns.add(new TableColumn<T>(name, function));
        return this;
    }

    public void addAll(Iterable<T> entries) {
        entries.forEach(this::addEntry);
    }

    public void addEntry(T entry) {
        this.columns.forEach(column -> column.processValue(entry));
        ++this.entryCount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (TableColumn<T> column : this.columns) {
            builder.append(DIVIDER_COLUMN).append(" ").append(StringUtils.rightPad((String)column.getTitle(), (int)column.getMaxLength())).append(" ");
        }
        builder.append(DIVIDER_COLUMN).append(NEW_LINE);
        for (TableColumn<T> column : this.columns) {
            builder.append(DIVIDER_COLUMN).append(DIVIDER_ROW.repeat(column.getMaxLength() + 2));
        }
        builder.append(DIVIDER_COLUMN).append(NEW_LINE);
        for (int entryIndex = 0; entryIndex < this.entryCount; ++entryIndex) {
            for (TableColumn<T> column : this.columns) {
                builder.append(DIVIDER_COLUMN).append(" ").append(StringUtils.rightPad((String)column.getValue(entryIndex), (int)column.getMaxLength())).append(" ");
            }
            builder.append(DIVIDER_COLUMN);
            if (entryIndex == this.entryCount - 1) continue;
            builder.append(NEW_LINE);
        }
        return builder.toString();
    }

    public static class TableColumn<T> {
        private final String title;
        private final Function<T, Object> valueResolver;
        private final List<String> heldValues;
        private int maxLength;

        public TableColumn(String title, Function<T, Object> valueResolver) {
            this.title = title;
            this.valueResolver = valueResolver;
            this.heldValues = new LinkedList<String>();
            this.maxLength = this.title.length();
        }

        public String getTitle() {
            return this.title;
        }

        public String getValue(int index) {
            return this.heldValues.get(index);
        }

        public void processValue(T value) {
            String valueText = String.valueOf(this.valueResolver.apply(value));
            this.heldValues.add(valueText);
            if (valueText.length() > this.maxLength) {
                this.maxLength = valueText.length();
            }
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }
}

