/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.events.ClientEvents;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.ConfigureDevCapeC2SPacket;
import com.railwayteam.railways.util.packet.JourneymapConfigurePacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public record ModVersionPacket(String version) implements S2CPacket
{
    public ModVersionPacket(FriendlyByteBuf buf) {
        this(buf.m_130277_());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.version);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        if (!"1.6.12-alpha".equals(this.version) && player != null) {
            String msg = "Steam 'n' Rails version mismatch: Server is using version " + this.version + ", you are using version 1.6.12-alpha. This may cause problems.";
            Railways.LOGGER.warn(msg);
            player.m_5661_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.DARK_RED), false);
        }
        CRPackets.PACKETS.send(new JourneymapConfigurePacket(Mods.JOURNEYMAP.isLoaded));
        boolean useDevCape = (Boolean)CRConfigs.client().useDevCape.get();
        CRPackets.PACKETS.send(new ConfigureDevCapeC2SPacket(useDevCape));
        ClientEvents.previousDevCapeSetting = useDevCape;
    }
}

