/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.puffs;

import com.railwayteam.railways.content.smokestack.particles.CustomAnimatedTextureSheetParticle;
import com.railwayteam.railways.content.smokestack.particles.puffs.PuffSmokeParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PuffSmokeParticle
extends CustomAnimatedTextureSheetParticle {
    public static final int DOUBLE_SPEED_SENTINEL = 42;
    protected final boolean stationarySource;
    protected final RandomSource random;

    protected PuffSmokeParticle(ClientLevel level, double x, double y, double z, RandomSource random, boolean stationarySource, double ySpeed) {
        super(level, x, y, z, 0.0, ySpeed, 0.0);
        if (Mth.m_14082_((double)42.0, (double)ySpeed)) {
            this.f_107216_ *= 1.5;
        }
        this.f_107663_ = 1.0f;
        this.f_172258_ = 0.99f;
        this.random = random;
        this.stationarySource = stationarySource;
        this.m_107257_(random.m_216332_(65, 105) + (stationarySource ? 60 : 0));
    }

    @Override
    protected double getAnimationProgress() {
        int age = Math.min(this.f_107224_, this.f_107225_ - 1);
        double lifeFactor = (double)age / (double)this.f_107225_;
        double f = 0.1;
        lifeFactor = this.stationarySource ? lifeFactor * lifeFactor : Math.max(0.0, (lifeFactor - f) * (lifeFactor - f) - f * f);
        return lifeFactor;
    }

    public void m_5989_() {
        float diffusionScale;
        super.m_5989_();
        float f = diffusionScale = this.stationarySource ? 800.0f : 500.0f;
        if (this.f_107224_ > 350) {
            diffusionScale = 5000.0f;
        } else if (this.f_107224_ > 300) {
            diffusionScale = Mth.m_14179_((float)((float)(this.f_107224_ - 300) / 50.0f), (float)(this.stationarySource ? 800.0f : 500.0f), (float)5000.0f);
        }
        this.f_107215_ += (double)(this.random.m_188501_() / diffusionScale * (float)(this.random.m_188499_() ? 1 : -1));
        this.f_107217_ += (double)(this.random.m_188501_() / diffusionScale * (float)(this.random.m_188499_() ? 1 : -1));
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory<T extends PuffSmokeParticleData<T>>
    implements ParticleProvider<T> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull T type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PuffSmokeParticle particle = new PuffSmokeParticle(level, x, y, z, level.m_213780_(), ((PuffSmokeParticleData)type).stationary, ySpeed);
            int textureCount = 19;
            int idx = 0;
            if (Mth.m_14033_((float)((PuffSmokeParticleData)type).red, (float)-1.0f) && Mth.m_14033_((float)((PuffSmokeParticleData)type).green, (float)-1.0f) && Mth.m_14033_((float)((PuffSmokeParticleData)type).blue, (float)-1.0f)) {
                idx = 1;
            } else if (Mth.m_14033_((float)((PuffSmokeParticleData)type).red, (float)-2.0f) && Mth.m_14033_((float)((PuffSmokeParticleData)type).green, (float)-2.0f) && Mth.m_14033_((float)((PuffSmokeParticleData)type).blue, (float)-2.0f)) {
                idx = 2;
            } else if (Mth.m_14033_((float)((PuffSmokeParticleData)type).red, (float)((PuffSmokeParticleData)type).green) && Mth.m_14033_((float)((PuffSmokeParticleData)type).green, (float)((PuffSmokeParticleData)type).blue) && ((PuffSmokeParticleData)type).red < -2.0f && ((PuffSmokeParticleData)type).red >= -18.0f) {
                idx = (int)Math.abs(((PuffSmokeParticleData)type).red);
            }
            particle.m_108337_(this.spriteSet.m_5819_(idx, textureCount - 1));
            particle.f_107224_ = level.m_213780_().m_188503_(5);
            if (idx == 0) {
                particle.f_107227_ = ((PuffSmokeParticleData)type).red;
                particle.f_107228_ = ((PuffSmokeParticleData)type).green;
                particle.f_107229_ = ((PuffSmokeParticleData)type).blue;
            }
            particle.f_107663_ = ((PuffSmokeParticleData)type).getQuadSize();
            return particle;
        }
    }
}

