/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import java.util.Arrays;
import java.util.function.IntFunction;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;

public enum PreferredRender implements StringRepresentable
{
    BOTH(true, true),
    BACKTANK(true, false, ArmorItem.Type.CHESTPLATE),
    ELYTRA(false, true, ArmorItem.Type.CHESTPLATE);

    public static final IntFunction<PreferredRender> BY_ID;
    private final ArmorItem.Type[] allowedTypes;
    private final boolean renderBacktank;
    private final boolean renderElytra;

    private PreferredRender(boolean renderBacktank, boolean renderElytra, ArmorItem.Type ... allowedTypes) {
        this.allowedTypes = allowedTypes;
        this.renderBacktank = renderBacktank;
        this.renderElytra = renderElytra;
    }

    private PreferredRender(boolean renderBacktank, boolean renderElytra) {
        this(renderBacktank, renderElytra, ArmorItem.Type.values());
    }

    public boolean canBeSelected(ArmorItem item) {
        return Arrays.stream(this.allowedTypes).anyMatch(t -> item.m_266204_().equals(t));
    }

    public String m_7912_() {
        return this.name().toLowerCase();
    }

    public boolean shouldRenderBacktank() {
        return this.renderBacktank;
    }

    public boolean shouldRenderElytra() {
        return this.renderElytra;
    }

    static {
        BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])PreferredRender.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

