/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonKeysHandler {
    private static final Map<Player, Boolean> HOLDING_UP = new HashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_DOWN = new HashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_FORWARDS = new HashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_BACKWARDS = new HashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_LEFT = new HashMap<Player, Boolean>();
    private static final Map<Player, Boolean> HOLDING_RIGHT = new HashMap<Player, Boolean>();

    public static boolean isHoldingUp(Player player) {
        return HOLDING_UP.containsKey(player) && HOLDING_UP.get(player) != false;
    }

    public static boolean isHoldingDown(Player player) {
        return HOLDING_DOWN.containsKey(player) && HOLDING_DOWN.get(player) != false;
    }

    public static boolean isHoldingForwards(Player player) {
        return HOLDING_FORWARDS.containsKey(player) && HOLDING_FORWARDS.get(player) != false;
    }

    public static boolean isHoldingBackwards(Player player) {
        return HOLDING_BACKWARDS.containsKey(player) && HOLDING_BACKWARDS.get(player) != false;
    }

    public static boolean isHoldingLeft(Player player) {
        return HOLDING_LEFT.containsKey(player) && HOLDING_LEFT.get(player) != false;
    }

    public static boolean isHoldingRight(Player player) {
        return HOLDING_RIGHT.containsKey(player) && HOLDING_RIGHT.get(player) != false;
    }

    public static void update(Player player, boolean up, boolean down, boolean forwards, boolean backwards, boolean left, boolean right) {
        HOLDING_UP.put(player, up);
        HOLDING_DOWN.put(player, down);
        HOLDING_FORWARDS.put(player, forwards);
        HOLDING_BACKWARDS.put(player, backwards);
        HOLDING_LEFT.put(player, left);
        HOLDING_RIGHT.put(player, right);
    }

    public static void clear() {
        HOLDING_UP.clear();
        HOLDING_FORWARDS.clear();
        HOLDING_DOWN.clear();
        HOLDING_BACKWARDS.clear();
        HOLDING_LEFT.clear();
        HOLDING_RIGHT.clear();
    }

    public static void remove(Player player) {
        HOLDING_UP.remove(player);
        HOLDING_FORWARDS.remove(player);
        HOLDING_DOWN.remove(player);
        HOLDING_BACKWARDS.remove(player);
        HOLDING_LEFT.remove(player);
        HOLDING_RIGHT.remove(player);
    }

    @SubscribeEvent
    public void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        CommonKeysHandler.remove(event.getEntity());
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CommonKeysHandler.remove(event.getEntity());
    }
}

