/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.recipes;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.registries.ModRecipeTypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class BlazeBurnerLiquidRecipe
extends ProcessingRecipe<RecipeWrapper> {
    static int counter = 0;
    private final BlazeBurnerBlock.HeatLevel burnerLevel;

    public static BlazeBurnerLiquidRecipe create(Fluid from, BlazeBurnerBlock.HeatLevel to) {
        ResourceLocation recipeId = CreateQOL.asResource("blaze_burner_liquid_" + counter++);
        return (BlazeBurnerLiquidRecipe)new ProcessingRecipeBuilder(p -> new BlazeBurnerLiquidRecipe(p, to), recipeId).withFluidIngredients(new FluidIngredient[]{FluidIngredient.fromFluid((Fluid)from, (int)1000)}).build();
    }

    public BlazeBurnerLiquidRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)ModRecipeTypes.BLAZE_BURNER_LIQUIDS, params);
        this.burnerLevel = BlazeBurnerBlock.HeatLevel.NONE;
    }

    public BlazeBurnerLiquidRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params, BlazeBurnerBlock.HeatLevel burnerLevel) {
        super((IRecipeTypeInfo)ModRecipeTypes.BLAZE_BURNER_LIQUIDS, params);
        this.burnerLevel = burnerLevel;
    }

    public BlazeBurnerBlock.HeatLevel getBurnerLevel() {
        return this.burnerLevel;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        return false;
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }
}

