/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.compat.jei;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import fr.iglee42.createqualityoflife.recipes.BlazeBurnerLiquidRecipe;
import fr.iglee42.createqualityoflife.utils.liquidblazeburners.LiquidBlazeBurnerManager;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class BlazeBurnerLiquidCategory
extends CreateRecipeCategory<BlazeBurnerLiquidRecipe> {
    private final AnimatedBlazeBurner burner = new AnimatedBlazeBurner();

    public BlazeBurnerLiquidCategory(CreateRecipeCategory.Info<BlazeBurnerLiquidRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BlazeBurnerLiquidRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 5).setBackground(BlazeBurnerLiquidCategory.getRenderedSlot(), -1, -1).addFluidStack(((FluidStack)((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().get(0)).getFluid(), (long)((FluidIngredient)recipe.getFluidIngredients().get(0)).getRequiredAmount());
        ((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().forEach(fs -> {
            fs.getFluid().m_6859_();
            if (!fs.getFluid().m_6859_().equals(Items.f_41852_)) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemLike((ItemLike)fs.getFluid().m_6859_());
            }
        });
    }

    public void draw(BlazeBurnerLiquidRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 47);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 74, 10);
        this.burner.withHeat(recipe.getBurnerLevel()).draw(graphics, 73, 12);
        if (((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().get(0) != null) {
            LiquidBlazeBurnerManager.LiquidEntry entry = LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.get(((FluidStack)((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().get(0)).getFluid());
            int time = entry.burnTime() * entry.consumption() * 1000 / 20;
            graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)"1 ").m_7220_((Component)Component.m_237115_((String)"item.minecraft.bucket")).m_7220_((Component)Component.m_237113_((String)(" = " + BlazeBurnerLiquidCategory.formatDuration(time)))), 94, 60, 0xFFFFFF);
        }
    }

    public static String formatDuration(int totalSeconds) {
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        StringBuilder result = new StringBuilder();
        if (hours > 0) {
            result.append(hours).append("h ");
        }
        if (minutes > 0) {
            result.append(minutes).append("min ");
        }
        if (seconds > 0 || result.isEmpty()) {
            result.append(seconds).append("s");
        }
        return result.toString().trim();
    }
}

