/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ItemConfigButton
extends BoxWidget {
    public static final Couple<Color> COLOR_IDLE = Couple.create((Object)new Color(1623245055, true), (Object)new Color(817938687, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_HOVER = Couple.create((Object)new Color(-255803137, true), (Object)new Color(-1597980417, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_CLICK = Couple.create((Object)new Color(-1, true), (Object)new Color(-570425345, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_DISABLED = Couple.create((Object)new Color(-2138009456, true), (Object)new Color(0x20909090, true)).map(Color::setImmutable);
    @Nullable
    protected ItemStack item;
    @Nullable
    protected int index;
    @Nullable
    protected KeyMapping shortcut;
    protected LerpedFloat flash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, (double)0.1f, LerpedFloat.Chaser.EXP);
    private final Consumer<ItemConfigButton> onClick;

    public ItemConfigButton(int x, int y, Consumer<ItemConfigButton> onClick, int index) {
        this(x, y, 20, 20, onClick, index);
    }

    public ItemConfigButton(int x, int y, int width, int height, Consumer<ItemConfigButton> onClick, int index) {
        super(x, y, width, height);
        this.onClick = onClick;
        this.index = index;
        this.z = 420.0f;
        this.paddingX = 2.0f;
        this.paddingY = 2.0f;
        this.colorIdle = COLOR_IDLE;
        this.colorHover = COLOR_HOVER;
        this.colorClick = COLOR_CLICK;
        this.colorDisabled = COLOR_DISABLED;
        this.updateGradientFromState();
    }

    public <T extends ItemConfigButton> T showing(ItemStack item) {
        this.item = item;
        return (T)((Object)((ItemConfigButton)super.showingElement(GuiGameElement.of((ItemStack)item).scale(1.5).at(-4.0f, -4.0f))));
    }

    public void flash() {
        this.flash.updateChaseTarget(1.0f);
    }

    public void dim() {
        this.flash.updateChaseTarget(0.0f);
    }

    public void tick() {
        super.tick();
        this.flash.tickChaser();
    }

    protected void beforeRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);
        float flashValue = this.flash.getValue(partialTicks);
        if (flashValue > 0.1f) {
            float sin = 0.5f + 0.5f * Mth.m_14031_((float)(((float)AnimationTickHolder.getTicks((boolean)true) + partialTicks) / 10.0f));
            Color nc1 = new Color(255, 255, 255, Mth.m_14045_((int)(((Color)this.gradientColor.getFirst()).getAlpha() + 150), (int)0, (int)255));
            Color nc2 = new Color(155, 155, 155, Mth.m_14045_((int)(((Color)this.gradientColor.getSecond()).getAlpha() + 150), (int)0, (int)255));
            Couple newColors = Couple.create((Object)nc1, (Object)nc2);
            float finalSin = sin *= flashValue;
            this.gradientColor = this.gradientColor.mapWithParams((color, other) -> color.mixWith(other, finalSin), newColors);
        }
    }

    public void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(graphics, mouseX, mouseY, partialTicks);
        float fadeValue = this.fade.getValue();
        if (fadeValue < 0.1f) {
            return;
        }
        if (this.shortcut != null) {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, this.z + 10.0f);
            graphics.m_280137_(Minecraft.m_91087_().f_91062_, this.shortcut.m_90863_().getString().toLowerCase(Locale.ROOT), this.m_252754_() + this.f_93618_ / 2 + 8, this.m_252907_() + this.f_93619_ - 6, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).scaleAlpha(fadeValue).getRGB());
            poseStack.m_85849_();
        }
    }

    public boolean m_93696_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.shortcut != null && this.shortcut.m_90832_(keyCode, scanCode)) {
            this.gradientColor = this.getColorClick();
            this.startGradientAnimation(this.getColorForState(), 0.15);
            this.runCallback((float)this.f_93618_ / 2.0f, (float)this.f_93619_ / 2.0f);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_5716_(double x, double y) {
        super.m_5716_(x, y);
        this.onClick.accept(this);
    }

    @Nullable
    public ItemStack getItem() {
        return this.item;
    }

    public int getIndex() {
        return this.index;
    }
}

