/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.tabs;

import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.widget.Label;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTab;
import fr.iglee42.createqualityoflife.client.screens.widgets.ClickableScrollInput;
import fr.iglee42.createqualityoflife.client.screens.widgets.FloatScrollInput;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.ModGuiTextures;
import fr.iglee42.createqualityoflife.registries.ModItems;
import fr.iglee42.createqualityoflife.statue.Statue;
import fr.iglee42.createqualityoflife.statue.StatueMenu;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public class StatueTransformTab
extends StatueTab {
    private Label positionLabel;
    private EditBox posX;
    private EditBox posY;
    private EditBox posZ;
    private Label scaleLabel;
    private FloatScrollInput scale;
    private Label rotationLabel;
    private ClickableScrollInput rotationX;
    private ClickableScrollInput rotationY;
    private ClickableScrollInput rotationZ;

    public StatueTransformTab(int index, ConfigureStatueScreen parent) {
        super(index, ModItems.STATUE.m_5456_(), parent, "statue.transformTab");
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y) {
        for (ClickableScrollInput i : new ClickableScrollInput[]{this.rotationX, this.rotationY, this.rotationZ}) {
            int inputX = i.m_252754_();
            AllGuiTextures.TRAIN_PROMPT_L.render(graphics, inputX - 3, i.m_252907_());
            AllGuiTextures.TRAIN_PROMPT_R.render(graphics, inputX + i.m_5711_(), i.m_252907_());
            ModGuiTextures.SLIDER.render(graphics, inputX, i.m_252907_());
            float progress = (float)(i.getState() + 180) / 360.0f;
            AllGuiTextures.TRAIN_PROMPT_L.render(graphics, (int)((float)inputX + progress * (float)i.m_5711_() - 3.0f), i.m_252907_());
            AllGuiTextures.TRAIN_PROMPT_R.render(graphics, (int)((float)inputX + progress * (float)i.m_5711_()), i.m_252907_());
        }
        int inputX = this.scale.m_252754_();
        AllGuiTextures.TRAIN_PROMPT_L.render(graphics, inputX - 3, this.scale.m_252907_());
        AllGuiTextures.TRAIN_PROMPT_R.render(graphics, inputX + this.scale.m_5711_(), this.scale.m_252907_());
        ModGuiTextures.SLIDER.render(graphics, inputX, this.scale.m_252907_());
        float progress = this.scale.getState() / 10.0f;
        AllGuiTextures.TRAIN_PROMPT_L.render(graphics, (int)((float)inputX + progress * (float)this.scale.m_5711_() - 3.0f), this.scale.m_252907_());
        AllGuiTextures.TRAIN_PROMPT_R.render(graphics, (int)((float)inputX + progress * (float)this.scale.m_5711_()), this.scale.m_252907_());
        ModGuiTextures.COORDINATES.render(graphics, x + 2, y);
    }

    @Override
    public void forEachWidgets(Consumer<AbstractWidget> function) {
        function.accept((AbstractWidget)this.posX);
        function.accept((AbstractWidget)this.posY);
        function.accept((AbstractWidget)this.posZ);
        function.accept((AbstractWidget)this.positionLabel);
        function.accept((AbstractWidget)this.scaleLabel);
        function.accept((AbstractWidget)this.scale);
        function.accept((AbstractWidget)this.rotationX);
        function.accept((AbstractWidget)this.rotationY);
        function.accept((AbstractWidget)this.rotationZ);
        function.accept((AbstractWidget)this.rotationLabel);
    }

    private void setRotation(char axis, int rotation) {
        switch (axis) {
            case 'x': {
                this.getExampleStatue().setEntityXRotation(rotation);
                break;
            }
            case 'y': {
                this.getExampleStatue().m_146922_(rotation);
                break;
            }
            case 'z': {
                this.getExampleStatue().setEntityZRotation(rotation);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + axis);
            }
        }
    }

    public boolean keyPressed(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        String[] split;
        String coords;
        if (Screen.m_96630_((int)code) && (coords = Minecraft.m_91087_().f_91068_.m_90876_()) != null && !coords.isEmpty() && (split = (coords = coords.replaceAll(" ", ",")).split(",")).length == 3) {
            boolean valid = true;
            for (String s : split) {
                try {
                    Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    valid = false;
                }
            }
            if (this.calculateCoords(Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2])) == null) {
                return false;
            }
            if (valid) {
                this.posX.m_94144_(split[0]);
                this.posY.m_94144_(split[1]);
                this.posZ.m_94144_(split[2]);
            }
        }
        return false;
    }

    private Vec3 calculateCoords() {
        try {
            return this.calculateCoords(Double.parseDouble(this.posX.m_94155_()), Double.parseDouble(this.posY.m_94155_()), Double.parseDouble(this.posZ.m_94155_()));
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    private Vec3 calculateCoords(double x, double y, double z) {
        try {
            Vec3 newLocation = new Vec3(x, y, z);
            if (newLocation.m_82554_(this.getExampleStatue().m_20182_()) > (double)((Integer)CreateQOLConfigs.server().statueDistance.get()).intValue()) {
                return null;
            }
            return newLocation;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void updateCoords() {
        Vec3 newLocation = this.calculateCoords();
        if (newLocation != null) {
            this.getExampleStatue().m_6034_(newLocation.f_82479_, newLocation.f_82480_, newLocation.f_82481_);
            this.getParent().sendUpdatePacket();
        }
    }

    @Override
    public void initWidgets(int x, int y) {
        this.posX = new EditBox(Minecraft.m_91087_().f_91062_, x + 4, y + 5, 34, 18, CommonComponents.f_237098_);
        this.posY = new EditBox(Minecraft.m_91087_().f_91062_, x + 4 + 40, y + 5, 34, 18, CommonComponents.f_237098_);
        this.posZ = new EditBox(Minecraft.m_91087_().f_91062_, x + 4 + 80, y + 5, 34, 18, CommonComponents.f_237098_);
        this.positionLabel = new Label(x + 4, y - 10, (Component)CreateQOLLang.translateDirect("statue.position", new Object[0]));
        this.positionLabel.text = CreateQOLLang.translateDirect("statue.position", new Object[0]);
        for (EditBox widget : new EditBox[]{this.posX, this.posY, this.posZ}) {
            widget.m_94199_(6);
            widget.m_94182_(false);
            widget.m_94202_(0xFFFFFF);
            widget.m_93692_(false);
            widget.m_6375_(0.0, 0.0, 0);
            widget.m_94151_(s -> {
                if (!s.isEmpty()) {
                    this.updateCoords();
                }
            });
            widget.m_94153_(s -> {
                if (s.isEmpty() || s.equals("-")) {
                    return true;
                }
                try {
                    Double.parseDouble(s);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
        }
        this.posX.m_94144_("" + ((Statue)((Object)((StatueMenu)this.getParent().m_6262_()).contentHolder)).m_20182_().f_82479_);
        this.posY.m_94144_("" + ((Statue)((Object)((StatueMenu)this.getParent().m_6262_()).contentHolder)).m_20182_().f_82480_);
        this.posZ.m_94144_("" + ((Statue)((Object)((StatueMenu)this.getParent().m_6262_()).contentHolder)).m_20182_().f_82481_);
        this.scaleLabel = new Label(x + 4, y + 44 - 15, (Component)CreateQOLLang.translateDirect("statue.scale", new Object[0]));
        this.scaleLabel.text = CreateQOLLang.translateDirect("statue.scale", new Object[0]);
        this.scale = new FloatScrollInput(x + 4, y + 44, 119, 18);
        this.scale.withRange(0.1f, 10.0f);
        this.scale.withStepFunction(ctx -> Float.valueOf(ctx.control ? 1.0f : (ctx.shift ? 0.5f : 0.1f)));
        this.scale.calling(i -> {
            this.getExampleStatue().setEntityScale(i.floatValue());
            this.scale.titled(Component.m_237113_((String)("Scale: " + String.format("%.2f", Float.valueOf(this.scale.getState())))));
            this.getParent().sendUpdatePacket();
        });
        this.scale.setState(this.getExampleStatue().getEntityScale());
        this.scale.titled(Component.m_237113_((String)("Scale: " + String.format("%.2f", Float.valueOf(this.scale.getState())))));
        this.rotationLabel = new Label(x + 4, y + 88 - 15, (Component)CreateQOLLang.translateDirect("statue.rotation.cape", new Object[0]));
        this.rotationLabel.text = CreateQOLLang.translateDirect("statue.rotation.cape", new Object[0]);
        this.rotationX = new ClickableScrollInput(x + 4, y + 88, 119, 18);
        this.rotationX.withRange(-180, 180);
        this.rotationX.withStepFunction(ctx -> ctx.control ? 90 : (ctx.shift ? 45 : 1));
        this.rotationX.calling(i -> {
            this.setRotation('x', (int)i);
            this.rotationX.titled(Component.m_237113_((String)("X: " + i + "\u00b0")));
            this.getParent().sendUpdatePacket();
        });
        this.rotationX.setState((int)this.getExampleStatue().getEntityRotations().m_123156_());
        this.rotationX.titled(Component.m_237113_((String)("X: " + this.rotationX.getState() + "\u00b0")));
        this.rotationY = new ClickableScrollInput(x + 4, y + 110, 119, 18);
        this.rotationY.withRange(-180, 180);
        this.rotationY.withStepFunction(ctx -> ctx.control ? 90 : (ctx.shift ? 45 : 1));
        this.rotationY.calling(i -> {
            this.setRotation('y', (int)i);
            this.rotationY.titled(Component.m_237113_((String)("Y: " + i + "\u00b0")));
            this.getParent().sendUpdatePacket();
        });
        this.rotationY.setState((int)this.getExampleStatue().getEntityRotations().m_123157_());
        this.rotationY.titled(Component.m_237113_((String)("Y: " + this.rotationY.getState() + "\u00b0")));
        this.rotationZ = new ClickableScrollInput(x + 4, y + 132, 119, 18);
        this.rotationZ.withRange(-180, 180);
        this.rotationZ.withStepFunction(ctx -> ctx.control ? 90 : (ctx.shift ? 45 : 1));
        this.rotationZ.calling(i -> {
            this.setRotation('z', (int)i);
            this.rotationZ.titled(Component.m_237113_((String)("Z: " + i + "\u00b0")));
            this.getParent().sendUpdatePacket();
        });
        this.rotationZ.setState((int)this.getExampleStatue().getEntityRotations().m_123158_());
        this.rotationZ.titled(Component.m_237113_((String)("Z: " + this.rotationZ.getState() + "\u00b0")));
    }
}

