/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.tabs;

import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.widget.Label;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTab;
import fr.iglee42.createqualityoflife.client.screens.widgets.ClickableScrollInput;
import fr.iglee42.createqualityoflife.registries.ModGuiTextures;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class PartsRotationTab
extends StatueTab {
    private final PlayerModelPart part1;
    @Nullable
    private final PlayerModelPart part2;
    private Label part1Label;
    private ClickableScrollInput part1X;
    private ClickableScrollInput part1Y;
    private ClickableScrollInput part1Z;
    private Label part2Label;
    private ClickableScrollInput part2X;
    private ClickableScrollInput part2Y;
    private ClickableScrollInput part2Z;
    Map<ClickableScrollInput, Integer> inputs;

    public PartsRotationTab(int index, Item item, ConfigureStatueScreen parent, PlayerModelPart part1) {
        this(index, item, parent, part1, null);
    }

    public PartsRotationTab(int index, Item item, ConfigureStatueScreen parent, PlayerModelPart part1, @Nullable PlayerModelPart part2) {
        super(index, item, parent, "statue." + part1.name().toLowerCase() + "Tab");
        this.part1 = part1;
        this.part2 = part2;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y) {
        this.inputs.forEach((i, value) -> {
            int inputX = i.m_252754_();
            AllGuiTextures.TRAIN_PROMPT_L.render(graphics, inputX - 3, i.m_252907_());
            AllGuiTextures.TRAIN_PROMPT_R.render(graphics, inputX + i.m_5711_(), i.m_252907_());
            ModGuiTextures.SLIDER.render(graphics, inputX, i.m_252907_());
            float progress = (float)(value + 180) / 360.0f;
            AllGuiTextures.TRAIN_PROMPT_L.render(graphics, (int)((float)inputX + progress * (float)i.m_5711_() - 3.0f), i.m_252907_());
            AllGuiTextures.TRAIN_PROMPT_R.render(graphics, (int)((float)inputX + progress * (float)i.m_5711_()), i.m_252907_());
        });
    }

    @Override
    public void forEachWidgets(Consumer<AbstractWidget> function) {
        if (this.part1 != null) {
            function.accept((AbstractWidget)this.part1X);
            function.accept((AbstractWidget)this.part1Y);
            function.accept((AbstractWidget)this.part1Z);
            function.accept((AbstractWidget)this.part1Label);
        }
        if (this.part2 != null) {
            function.accept((AbstractWidget)this.part2X);
            function.accept((AbstractWidget)this.part2Y);
            function.accept((AbstractWidget)this.part2Z);
            function.accept((AbstractWidget)this.part2Label);
        }
    }

    private Rotations getRotationsForPart(PlayerModelPart part) {
        return switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerModelPart.CAPE -> this.getExampleStatue().getEntityRotations();
            case PlayerModelPart.JACKET -> this.getExampleStatue().getBodyPose();
            case PlayerModelPart.LEFT_SLEEVE -> this.getExampleStatue().getLeftArmPose();
            case PlayerModelPart.RIGHT_SLEEVE -> this.getExampleStatue().getRightArmPose();
            case PlayerModelPart.LEFT_PANTS_LEG -> this.getExampleStatue().getLeftLegPose();
            case PlayerModelPart.RIGHT_PANTS_LEG -> this.getExampleStatue().getRightLegPose();
            case PlayerModelPart.HAT -> this.getExampleStatue().getHeadPose();
        };
    }

    private void setRotation(PlayerModelPart part, Rotations rotations) {
        switch (part) {
            case CAPE: {
                this.getExampleStatue().setEntityRotations(rotations.m_123156_(), rotations.m_123157_(), rotations.m_123158_());
                break;
            }
            case JACKET: {
                this.getExampleStatue().setBodyPose(rotations);
                break;
            }
            case LEFT_SLEEVE: {
                this.getExampleStatue().setLeftArmPose(rotations);
                break;
            }
            case RIGHT_SLEEVE: {
                this.getExampleStatue().setRightArmPose(rotations);
                break;
            }
            case LEFT_PANTS_LEG: {
                this.getExampleStatue().setLeftLegPose(rotations);
                break;
            }
            case RIGHT_PANTS_LEG: {
                this.getExampleStatue().setRightLegPose(rotations);
                break;
            }
            case HAT: {
                this.getExampleStatue().setHeadPose(rotations);
            }
        }
    }

    private void setRotation(PlayerModelPart part, char axis, int rotation) {
        Rotations rotations = this.getRotationsForPart(part);
        switch (axis) {
            case 'x': {
                rotations = new Rotations((float)rotation, rotations.m_123157_(), rotations.m_123158_());
                break;
            }
            case 'y': {
                rotations = new Rotations(rotations.m_123156_(), (float)rotation, rotations.m_123158_());
                break;
            }
            case 'z': {
                rotations = new Rotations(rotations.m_123156_(), rotations.m_123157_(), (float)rotation);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + axis);
            }
        }
        this.setRotation(part, rotations);
    }

    @Override
    public void initWidgets(int x, int y) {
        if (this.part1 != null && this.part2 == null) {
            y += (158 - y) / 2;
        }
        this.inputs = new HashMap<ClickableScrollInput, Integer>();
        if (this.part1 != null) {
            this.part1Label = new Label(x + 4, y - 10, (Component)CreateQOLLang.translateDirect("statue.rotation." + this.part1.name().toLowerCase(), new Object[0]));
            this.part1Label.text = CreateQOLLang.translateDirect("statue.rotation." + this.part1.name().toLowerCase(), new Object[0]);
            this.part1X = new ClickableScrollInput(x + 4, y, 119, 18);
            this.part1X.calling(i -> {
                this.setRotation(this.part1, 'x', (int)i);
                this.inputs.put(this.part1X, (Integer)i);
                this.part1X.titled(Component.m_237113_((String)("X: " + i + "\u00b0")));
                this.getParent().sendUpdatePacket();
            });
            this.part1Y = new ClickableScrollInput(x + 4, y + 22, 119, 18);
            this.part1Y.calling(i -> {
                this.setRotation(this.part1, 'y', (int)i);
                this.inputs.put(this.part1Y, (Integer)i);
                this.part1Y.titled(Component.m_237113_((String)("Y: " + i + "\u00b0")));
                this.getParent().sendUpdatePacket();
            });
            this.part1Z = new ClickableScrollInput(x + 4, y + 44, 119, 18);
            this.part1Z.calling(i -> {
                this.setRotation(this.part1, 'z', (int)i);
                this.inputs.put(this.part1Z, (Integer)i);
                this.part1Z.titled(Component.m_237113_((String)("Z: " + i + "\u00b0")));
                this.getParent().sendUpdatePacket();
            });
            this.setupConfigForInputs(this.getRotationsForPart(this.part1), this.part1X, this.part1Y, this.part1Z);
        }
        if (this.part2 != null) {
            this.part2Label = new Label(x + 4, y + 88 - 10, (Component)CreateQOLLang.translateDirect("statue.rotation." + this.part2.name().toLowerCase(), new Object[0]));
            this.part2Label.text = CreateQOLLang.translateDirect("statue.rotation." + this.part2.name().toLowerCase(), new Object[0]);
            this.part2X = new ClickableScrollInput(x + 4, y + 88, 119, 18);
            this.part2X.calling(i -> {
                this.setRotation(this.part2, 'x', (int)i);
                this.inputs.put(this.part2X, (Integer)i);
                this.part2X.titled(Component.m_237113_((String)("X: " + i + "\u00b0")));
                this.getParent().sendUpdatePacket();
            });
            this.part2Y = new ClickableScrollInput(x + 4, y + 110, 119, 18);
            this.part2Y.calling(i -> {
                this.setRotation(this.part2, 'y', (int)i);
                this.inputs.put(this.part2Y, (Integer)i);
                this.part2Y.titled(Component.m_237113_((String)("Y: " + i + "\u00b0")));
                this.getParent().sendUpdatePacket();
            });
            this.part2Z = new ClickableScrollInput(x + 4, y + 132, 119, 18);
            this.part2Z.calling(i -> {
                this.setRotation(this.part2, 'z', (int)i);
                this.inputs.put(this.part2Z, (Integer)i);
                this.part2Z.titled(Component.m_237113_((String)("Z: " + i + "\u00b0")));
                this.getParent().sendUpdatePacket();
            });
            this.setupConfigForInputs(this.getRotationsForPart(this.part2), this.part2X, this.part2Y, this.part2Z);
        }
    }

    private void setupConfigForInputs(Rotations rotations, ClickableScrollInput ... inputs) {
        for (int index = 0; index < inputs.length; ++index) {
            ClickableScrollInput input = inputs[index];
            input.withRange(-180, 180);
            input.withStepFunction(ctx -> ctx.control ? 90 : (ctx.shift ? 45 : 1));
            input.setState(switch (index) {
                case 0 -> (int)rotations.m_123156_();
                case 1 -> (int)rotations.m_123157_();
                case 2 -> (int)rotations.m_123158_();
                default -> throw new IllegalStateException("Unexpected value: " + index);
            });
            input.titled(Component.m_237113_((String)((index == 0 ? "X" : (index == 1 ? "Y" : "Z")) + ": " + input.getState() + "\u00b0")));
            this.inputs.put(input, input.getState());
        }
    }
}

