/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blocks;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.drill.DrillBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import fr.iglee42.createqualityoflife.blockentitites.ChippedSawBlockEntity;
import fr.iglee42.createqualityoflife.registries.ModBlockEntities;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChippedSawBlock
extends HorizontalKineticBlock
implements IBE<ChippedSawBlockEntity> {
    public static final BooleanProperty FLIPPED = BooleanProperty.m_61465_((String)"flipped");
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public ChippedSawBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FLIPPED}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        return (BlockState)stateForPlacement.m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(context.m_8125_().m_122421_() == Direction.AxisDirection.POSITIVE));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        BlockState newState = super.m_6843_(state, rot);
        if (rot.ordinal() % 2 == 1) {
            newState = (BlockState)newState.m_61122_((Property)FLIPPED);
        }
        if (rot == Rotation.CLOCKWISE_180) {
            newState = (BlockState)newState.m_61122_((Property)FLIPPED);
        }
        return newState;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        BlockState newState = super.m_6943_(state, mirrorIn);
        if (mirrorIn == Mirror.FRONT_BACK) {
            newState = (BlockState)newState.m_61122_((Property)FLIPPED);
        }
        if (mirrorIn == Mirror.LEFT_RIGHT) {
            newState = (BlockState)newState.m_61122_((Property)FLIPPED);
        }
        return newState;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.CASING_12PX.get(Direction.UP);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!player.m_6144_() && player.m_36326_() && placementHelper.matchesItem(heldItem) && placementHelper.getOffset(player, worldIn, state, pos, hit).placeInWorld(worldIn, (BlockItem)heldItem.m_41720_(), player, handIn, hit).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_() || !player.m_21120_(handIn).m_41619_()) {
            return InteractionResult.PASS;
        }
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            for (int i = 0; i < be.inventory.getSlots(); ++i) {
                ItemStack heldItemStack = be.inventory.getStackInSlot(i);
                if (worldIn.f_46443_ || heldItemStack.m_41619_()) continue;
                player.m_150109_().m_150079_(heldItemStack);
            }
            be.inventory.clear();
            be.notifyUpdate();
            return InteractionResult.SUCCESS;
        });
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            return;
        }
        if (!new AABB(pos).m_82406_((double)0.1f).m_82381_(entityIn.m_20191_())) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.getSpeed() == 0.0f) {
                return;
            }
            entityIn.m_6469_(CreateDamageSources.saw((Level)worldIn), (float)DrillBlock.getDamage((float)be.getSpeed()));
        });
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.m_9236_().f_46443_) {
            return;
        }
        BlockPos pos = entityIn.m_20183_();
        this.withBlockEntityDo((BlockGetter)entityIn.m_9236_(), pos, be -> {
            if (be.getSpeed() == 0.0f) {
                return;
            }
            be.insertItem((ItemEntity)entityIn);
        });
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122424_() || face == state.m_61143_(HORIZONTAL_FACING);
    }

    public Class<ChippedSawBlockEntity> getBlockEntityClass() {
        return ChippedSawBlockEntity.class;
    }

    public BlockEntityType<? extends ChippedSawBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.CHIPPED_SAW.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return itemStack -> {
                BlockItem b;
                Item patt7548$temp = itemStack.m_41720_();
                return patt7548$temp instanceof BlockItem && (b = (BlockItem)patt7548$temp).m_40614_() instanceof ChippedSawBlock;
            };
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> state.m_60734_() instanceof ChippedSawBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)Direction.Axis.Y, dir -> world.m_8055_(pos.m_121945_(dir)).m_247087_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)((BlockState)s.m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)((Direction)state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)))).m_61124_((Property)FLIPPED, (Comparable)((Boolean)state.m_61143_((Property)FLIPPED))));
        }
    }
}

