/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife;

import com.mojang.logging.LogUtils;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import fr.iglee42.createqualityoflife.CreateQOLClient;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.conditions.FeatureLoadedCondition;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.config.CreateQOLFeaturesConfig;
import fr.iglee42.createqualityoflife.items.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.registries.ModBlockEntities;
import fr.iglee42.createqualityoflife.registries.ModBlocks;
import fr.iglee42.createqualityoflife.registries.ModCreativeModeTabs;
import fr.iglee42.createqualityoflife.registries.ModEntityTypes;
import fr.iglee42.createqualityoflife.registries.ModItems;
import fr.iglee42.createqualityoflife.registries.ModMenuTypes;
import fr.iglee42.createqualityoflife.registries.ModPackets;
import fr.iglee42.createqualityoflife.registries.ModRecipeTypes;
import fr.iglee42.createqualityoflife.statue.animation.PublishedAnimationsManager;
import fr.iglee42.createqualityoflife.utils.Features;
import fr.iglee42.createqualityoflife.utils.liquidblazeburners.LiquidBlazeBurnerReloadListener;
import java.io.IOException;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="createqol")
public class CreateQOL {
    public static final String MODID = "createqol";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"createqol").defaultCreativeTab((ResourceKey)null);

    public CreateQOL() throws IOException, IllegalAccessException {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        CreateQOLFeaturesConfig.load();
        REGISTRATE.registerEventListeners(modEventBus);
        ModBlocks.register();
        ModBlockEntities.register();
        ModItems.register();
        ModCreativeModeTabs.register(modEventBus);
        ModPackets.registerPackets();
        ModRecipeTypes.register(modEventBus);
        ModEntityTypes.ENTITIES.register(modEventBus);
        ModMenuTypes.register();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateQOLClient.onCtorClient(modEventBus, forgeEventBus));
        CreateQOLConfigs.register(ModLoadingContext.get());
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ModEntityTypes::registerEntityAttributes);
        forgeEventBus.addListener(this::removeFallDamage);
        forgeEventBus.addListener(this::registerReloadListener);
        forgeEventBus.addListener(this::playerJoin);
        forgeEventBus.addListener(this::onWorldTick);
        forgeEventBus.addListener(this::itemTooltips);
    }

    private void registerReloadListener(AddReloadListenerEvent event) {
        if (!CreateQOL.isActivate(Features.LIQUID_BLAZE_BURNER)) {
            return;
        }
        event.addListener((PreparableReloadListener)LiquidBlazeBurnerReloadListener.INSTANCE);
    }

    public static boolean isChippedLoaded() {
        return ModList.get().isLoaded("chipped");
    }

    public static boolean isActivate(Features feature) {
        return feature.getConfig();
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CraftingHelper.register((IConditionSerializer)FeatureLoadedCondition.Serializer.INSTANCE));
    }

    public void removeFallDamage(LivingDamageEvent event) {
        if (!event.getSource().equals(event.getEntity().m_9236_().m_269111_().m_268989_())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_6844_(EquipmentSlot.CHEST).m_150930_(ModItems.SHADOW_RADIANCE_CHESTPLATE.m_5456_())) {
            ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
            if (BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty()) {
                return;
            }
            if (ShadowRadianceChestplate.isFansEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ShadowRadianceChestplate.hasPropeller(stack)) {
                event.setCanceled(true);
            }
        }
    }

    private void playerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (event.getLevel().f_46443_) {
            return;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (event.getLevel().m_7654_() == null) {
            return;
        }
        if (event.getLevel().m_7654_().m_129944_(p.m_36316_()) < 1) {
            return;
        }
        if (CreateQOL.isActivate(Features.STATUE) && ((Boolean)CreateQOLConfigs.server().experimentalWarning.get()).booleanValue()) {
            player.m_5661_((Component)Component.m_237113_((String)"Warning: Statue are still a beta feature, some bugs and crash might appear.\nPlease report them on https://issues-qol.iglee.fr").m_130940_(ChatFormatting.YELLOW), false);
        }
    }

    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.level.f_46443_) {
            return;
        }
        PublishedAnimationsManager manager = PublishedAnimationsManager.get(event.level);
        manager.tick((ServerLevel)event.level);
    }

    public void itemTooltips(ItemTooltipEvent event) {
        if (!event.getItemStack().m_150930_(Items.f_42688_)) {
            return;
        }
        if (CreateQOL.isActivate(Features.SHADOW_RADIANCE) && ((Boolean)CreateQOLConfigs.server().elytraBoostAllowed.get()).booleanValue() && ((Boolean)CreateQOLConfigs.server().useFireworksForBoost.get()).booleanValue()) {
            event.getToolTip().add(CreateQOLLang.translateDirect("chestplate.use_fireworks", new Object[0]).m_130940_(ChatFormatting.YELLOW));
        }
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

