/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.packet;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.packet.EntityIDSyncPacket;

public class PacketHandler {
    public static final SimpleChannel INSTANCE = PacketHandler.buildChannel("main", "1");
    public static final SimpleChannel INGREDIENT_SYNC;
    public static final ThreadLocal<Boolean> CLIENT_HAS_SMART_INGREDIENT_SYNC;

    private static SimpleChannel buildChannel(String name, String version) {
        return NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("modernfix", name), () -> version, (Predicate)NetworkRegistry.acceptMissingOr((String)version), (Predicate)NetworkRegistry.acceptMissingOr((String)version));
    }

    public static void register() {
        INSTANCE.registerMessage(1, EntityIDSyncPacket.class, EntityIDSyncPacket::serialize, EntityIDSyncPacket::deserialize, PacketHandler::handleSyncPacket);
    }

    private static void handleSyncPacket(EntityIDSyncPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketHandler.lambda$handleSyncPacket$3((Supplier)contextSupplier, packet));
    }

    private static /* synthetic */ void lambda$handleSyncPacket$3(Supplier contextSupplier, EntityIDSyncPacket packet) {
        ((NetworkEvent.Context)contextSupplier.get()).enqueueWork(() -> ModernFixClient.handleEntityIDSync(packet));
        ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
    }

    static {
        SimpleChannel ingredientChannel = ModernFixMixinPlugin.instance.isOptionEnabled("perf.smart_ingredient_sync.Channel") ? PacketHandler.buildChannel("ingredient_sync", "1") : null;
        INGREDIENT_SYNC = ingredientChannel;
        CLIENT_HAS_SMART_INGREDIENT_SYNC = ThreadLocal.withInitial(() -> false);
    }
}

