/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources;

import com.google.common.base.Stopwatch;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.forge.dynresources.ModelBakeEventHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ForgeHooksClient.class})
public class ForgeHooksClientMixin {
    @Redirect(method={"onModifyBakingResult"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/ModLoader;postEvent(Lnet/minecraftforge/eventbus/api/Event;)V"), remap=false)
    private static void postNamespacedKeySetEvent(ModLoader loader, Event event) {
        if (!ModLoader.isLoadingStateValid()) {
            return;
        }
        ModelEvent.ModifyBakingResult bakeEvent = (ModelEvent.ModifyBakingResult)event;
        Stopwatch globalTimer = Stopwatch.createStarted();
        Stopwatch selfTimer = Stopwatch.createStarted();
        ModelBakeEventHelper helper = new ModelBakeEventHelper(bakeEvent.getModels());
        selfTimer.stop();
        Method acceptEv = ObfuscationReflectionHelper.findMethod(ModContainer.class, (String)"acceptEvent", (Class[])new Class[]{Event.class});
        Object2ObjectOpenHashMap times = new Object2ObjectOpenHashMap();
        times.put("modernfix", selfTimer);
        ModList.get().forEachModContainer((arg_0, arg_1) -> ForgeHooksClientMixin.lambda$postNamespacedKeySetEvent$1(helper, bakeEvent, (Map)times, acceptEv, arg_0, arg_1));
        globalTimer.stop();
        if (globalTimer.elapsed(TimeUnit.SECONDS) >= 1L) {
            ModernFix.LOGGER.warn("Posting dynamic ModelEvent.ModifyBakingResult to mods took {}, breakdown below:", (Object)globalTimer);
            times.entrySet().stream().sorted(Comparator.comparing(e -> ((Stopwatch)e.getValue()).elapsed()).reversed()).filter(e -> ((Stopwatch)e.getValue()).elapsed(TimeUnit.MILLISECONDS) > 50L).forEach(entry -> ModernFix.LOGGER.warn("    {}: {}", entry.getKey(), (Object)((Stopwatch)entry.getValue()).toString()));
        }
    }

    private static /* synthetic */ void lambda$postNamespacedKeySetEvent$1(ModelBakeEventHelper helper, ModelEvent.ModifyBakingResult bakeEvent, Map times, Method acceptEv, String id, ModContainer mc) {
        Map<ResourceLocation, BakedModel> newRegistry = helper.wrapRegistry(id);
        ModelEvent.ModifyBakingResult postedEvent = new ModelEvent.ModifyBakingResult(newRegistry, bakeEvent.getModelBakery());
        Stopwatch timer = times.computeIfAbsent(id, $ -> Stopwatch.createUnstarted());
        timer.start();
        try {
            acceptEv.invoke((Object)mc, postedEvent);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        timer.stop();
    }
}

