/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.GroundFinder;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.Tags;

public class SubterraneanGroundFinder
implements GroundFinder {
    private static final List<BlockPos> NO_LAYERS = Collections.singletonList(BlockPos.f_121853_);

    protected boolean isReplaceable(LevelAccessor level, BlockPos pos) {
        return (level.m_46859_(pos) || level.m_8055_(pos).m_204336_(BlockTags.f_278411_)) && level.m_8055_(pos).m_60819_().m_76178_();
    }

    protected int getTopY(LevelAccessor level, BlockPos pos) {
        return level.m_46865_(pos).m_5885_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_());
    }

    protected ArrayList<Integer> findSubterraneanLayerHeights(LevelAccessor level, BlockPos start) {
        int maxY = this.getTopY(level, start);
        int minY = level.m_141937_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(start.m_123341_(), minY, start.m_123343_());
        ArrayList<Integer> layers = new ArrayList<Integer>();
        while (CoordUtils.inRange((BlockPos)pos, minY, maxY)) {
            while (!this.isReplaceable(level, (BlockPos)pos) && CoordUtils.inRange((BlockPos)pos, minY, maxY)) {
                pos.m_122175_(Direction.UP, 4);
            }
            while (this.isReplaceable(level, (BlockPos)pos) && CoordUtils.inRange((BlockPos)pos, minY, maxY)) {
                pos.m_122173_(Direction.DOWN);
            }
            if (this.isReplaceable(level, pos.m_6630_(6))) {
                layers.add(pos.m_123342_());
            }
            pos.m_122175_(Direction.UP, 8);
            while (this.isReplaceable(level, (BlockPos)pos) && CoordUtils.inRange((BlockPos)pos, minY, maxY)) {
                pos.m_122175_(Direction.UP, 4);
            }
        }
        if (layers.size() > 0) {
            layers.remove(layers.size() - 1);
        }
        return layers;
    }

    @Override
    public List<BlockPos> findGround(LevelAccessor level, BlockPos start, @Nullable Heightmap.Types heightmap) {
        ArrayList<Integer> layers = this.findSubterraneanLayerHeights(level, start);
        if (layers.size() < 1) {
            return NO_LAYERS;
        }
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        for (int y : layers) {
            BlockPos pos = new BlockPos(start.m_123341_(), y, start.m_123343_());
            if (!level.m_6042_().f_63856_() && !level.m_204166_(pos).m_203656_(Tags.Biomes.IS_UNDERGROUND)) continue;
            positions.add(pos);
        }
        return positions;
    }
}

