/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.RadiusCoordinator;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class BiomeRadiusCoordinator
implements RadiusCoordinator {
    public PerlinSimplexNoise noiseGenerator = new PerlinSimplexNoise((RandomSource)new WorldgenRandom(WorldgenRandom.Algorithm.LEGACY.m_224687_(96L)), new ArrayList<Integer>(Collections.singletonList(1)));
    protected final LevelAccessor level;
    protected final ResourceLocation dimensionName;
    protected int pass;
    protected Function<Integer, Integer> chunkMultipass;

    public BiomeRadiusCoordinator(ResourceLocation dimensionName, LevelAccessor level) {
        this.level = level;
        this.dimensionName = dimensionName;
    }

    @Override
    public int getRadiusAtCoords(int x, int z) {
        int rad = this.chunkMultipass.apply(this.pass);
        if (rad >= 2 && rad <= 8) {
            return rad;
        }
        double scale = 128.0;
        Holder biome = this.level.m_203675_(x + 8 >> 2, this.level.m_151558_() >> 2, z + 8 >> 2);
        double noiseDensity = (this.noiseGenerator.m_75449_((double)x / 128.0, (double)z / 128.0, false) + 1.0) / 2.0;
        double density = BiomeDatabases.getDimensionalOrDefault(this.dimensionName).getDensitySelector((Holder<Biome>)biome).getDensity(this.level.m_213780_(), noiseDensity);
        double size = (1.0 - density) * 9.0;
        int kindaRandom = (x * 674365771 ^ z * 254326997) >> 4;
        int shakelow = (kindaRandom & 3) % 3;
        int shakehigh = (kindaRandom & 0xC) % 3;
        return Mth.m_14045_((int)((int)size), (int)(2 + shakelow), (int)(8 - shakehigh));
    }

    @Override
    public boolean runPass(int chunkX, int chunkZ, int pass) {
        this.pass = pass;
        if (pass == 0) {
            Holder biome = this.level.m_203675_((chunkX << 4) + 8 >> 2, this.level.m_151558_() >> 2, (chunkZ << 4) + 8 >> 2);
            this.chunkMultipass = BiomeDatabases.getDimensionalOrDefault(this.dimensionName).getMultipass((Holder<Biome>)biome);
        }
        return this.chunkMultipass.apply(pass) >= 0;
    }
}

