/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.google.common.collect.Iterables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HugeMushroomGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> MUSHROOM_BLOCK = ConfigurationProperty.block("mushroom");
    public static final ConfigurationProperty<Block> STEM_BLOCK = ConfigurationProperty.block("stem");
    private int height = -1;
    static final SimpleVoxmap BROWN_CAP = new SimpleVoxmap(7, 1, 7, new byte[]{0, 1, 2, 2, 2, 3, 0, 1, 5, 5, 5, 5, 5, 3, 4, 5, 5, 5, 5, 5, 6, 4, 5, 5, 5, 5, 5, 6, 4, 5, 5, 5, 5, 5, 6, 7, 5, 5, 5, 5, 5, 9, 0, 7, 8, 8, 8, 9, 0}).setCenter(new BlockPos(3, 0, 3));
    static final SimpleVoxmap BROWN_CAP_MEDIUM = new SimpleVoxmap(5, 1, 5, new byte[]{0, 1, 2, 3, 0, 1, 5, 5, 5, 3, 4, 5, 5, 5, 6, 7, 5, 5, 5, 9, 0, 7, 8, 9, 0}).setCenter(new BlockPos(2, 0, 2));
    static final SimpleVoxmap BROWN_CAP_SMALL = new SimpleVoxmap(3, 1, 3, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}).setCenter(new BlockPos(1, 0, 1));
    static final SimpleVoxmap RED_CAP = new SimpleVoxmap(5, 4, 5, new byte[]{0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0, 4, 5, 6, 0, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 3, 2));
    static final SimpleVoxmap RED_CAP_SHORT = new SimpleVoxmap(5, 3, 5, new byte[]{0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0, 4, 5, 6, 0, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 2, 2));
    static final SimpleVoxmap RED_CAP_SMALL = new SimpleVoxmap(3, 2, 3, new byte[]{1, 2, 3, 4, 10, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9}).setCenter(new BlockPos(1, 1, 1));

    public HugeMushroomGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MUSHROOM_BLOCK, STEM_BLOCK);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MUSHROOM_BLOCK, Blocks.f_50181_)).with(STEM_BLOCK, Blocks.f_50182_);
    }

    public HugeMushroomGenFeature setHeight(int height) {
        this.height = height;
        return this;
    }

    protected SimpleVoxmap getCapForHeight(Block mushroomBlock, int height) {
        if (mushroomBlock == Blocks.f_50180_) {
            switch (height) {
                case 2: 
                case 3: {
                    return BROWN_CAP_SMALL;
                }
                case 4: 
                case 5: {
                    return BROWN_CAP_MEDIUM;
                }
            }
            return BROWN_CAP;
        }
        switch (height) {
            case 2: {
                return BROWN_CAP_SMALL;
            }
            case 3: {
                return RED_CAP_SMALL;
            }
            case 4: {
                return RED_CAP_SHORT;
            }
        }
        return RED_CAP;
    }

    protected int getMushroomHeight(LevelAccessor level, BlockPos rootPos, Biome biome, RandomSource random, int radius, SafeChunkBounds safeBounds) {
        return this.height > 0 ? this.height : random.m_188503_(9) + 2;
    }

    @Override
    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        BlockPos genPos = rootPos.m_7494_();
        int height = this.getMushroomHeight(level, rootPos, (Biome)context.biome().get(), context.random(), context.radius(), context.bounds());
        BlockState soilState = level.m_8055_(rootPos);
        if (context.species().isAcceptableSoilForWorldgen(level, rootPos, soilState)) {
            Block mushroomBlock = configuration.get(MUSHROOM_BLOCK);
            if (mushroomBlock == null) {
                mushroomBlock = context.random().m_188499_() ? Blocks.f_50180_ : Blocks.f_50181_;
            }
            SimpleVoxmap capMap = this.getCapForHeight(mushroomBlock, height);
            BlockPos capPos = genPos.m_6630_(height - 1);
            BlockBounds capBounds = capMap.getBounds().move(capPos);
            if (context.bounds().inBounds(capBounds, true)) {
                for (Object mutPos : Iterables.concat((Iterable)BlockPos.m_121940_((BlockPos)BlockPos.f_121853_.m_6625_(capMap.getLenY()), (BlockPos)BlockPos.f_121853_.m_6625_(height - 1)), capMap.getAllNonZero())) {
                    BlockPos dPos = mutPos.m_121955_((Vec3i)capPos);
                    BlockState state = level.m_8055_(dPos);
                    if (state.m_247087_()) continue;
                    return true;
                }
                BlockState stemState = configuration.get(STEM_BLOCK).m_49966_();
                for (SimpleVoxmap.Cell cell : capMap.getAllNonZeroCells()) {
                    level.m_7731_(capPos.m_121955_((Vec3i)cell.getPos()), this.getMushroomStateForValue(mushroomBlock, stemState, cell.getValue(), cell.getPos().m_123342_()), 2);
                }
                int stemLen = height - capMap.getLenY();
                for (int y = 0; y < stemLen; ++y) {
                    level.m_7731_(genPos.m_6630_(y), stemState, 2);
                }
                return true;
            }
        }
        return true;
    }

    protected BlockState getMushroomStateForValue(Block mushroomBlock, BlockState stemBlock, int value, int y) {
        if (value == 10) {
            return stemBlock;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)mushroomBlock.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(y >= -1))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(value >= 1 && value <= 3))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(value >= 7 && value <= 9))).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(value == 1 || value == 4 || value == 7))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(value % 3 == 0));
    }
}

