/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources;

import com.ferreusveritas.dynamictrees.api.resource.TreeResourcePack;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FlatTreeResourcePack
extends PathPackResources
implements TreeResourcePack {
    private static final Logger LOGGER = LogUtils.getLogger();

    public FlatTreeResourcePack(String packId, boolean isBuiltin, Path source) {
        super(packId, isBuiltin, source);
    }

    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation location) {
        return this.m_8017_(FlatTreeResourcePack.getPathFromLocation(location));
    }

    private static String[] getPathFromLocation(ResourceLocation location) {
        String[] parts = location.m_135815_().split("/");
        String[] result = new String[parts.length + 1];
        result[0] = location.m_135827_();
        System.arraycopy(parts, 0, result, 1, parts.length);
        return result;
    }

    public void m_8031_(@Nullable PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        FileUtil.m_245538_((String)path).get().ifLeft(parts -> net.minecraft.server.packs.PathPackResources.m_246914_((String)namespace, (Path)this.resolve(new String[]{namespace}).toAbsolutePath(), (List)parts, (PackResources.ResourceOutput)resourceOutput)).ifRight(dataResult -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)dataResult.message()));
    }

    public Set<String> m_5698_(@Nullable PackType type) {
        Set<String> set;
        block8: {
            Path root = this.resolve(new String[0]);
            Stream<Path> walker = Files.walk(root, 1, new FileVisitOption[0]);
            try {
                set = walker.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(root::relativize).filter(p -> p.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                if (walker == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Set.of();
                }
            }
            walker.close();
        }
        return set;
    }
}

