/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.baked;

import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.models.baked.BasicBranchBlockBakedModel;
import com.ferreusveritas.dynamictrees.models.modeldata.ModelConnections;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class BasicRootsBlockBakedModel
extends BasicBranchBlockBakedModel {
    private final BakedModel[][] sleeveFaces = new BakedModel[6][8];

    public BasicRootsBlockBakedModel(IGeometryBakingContext customData, ResourceLocation modelLocation, ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        super(customData, modelLocation, barkTextureLocation, ringsTextureLocation, spriteGetter);
        this.initModels();
    }

    private void initModels() {
        if (this.getRenderType() == RenderType.m_110451_()) {
            for (int i = 0; i < 8; ++i) {
                int radius = i + 1;
                for (Direction dir : Direction.values()) {
                    this.sleeveFaces[dir.m_122411_()][i] = this.bakeSleeveFace(radius, dir, this.ringsTexture);
                }
            }
        }
    }

    @Override
    public BakedModel bakeSleeve(int radius, Direction dir, TextureAtlasSprite bark) {
        boolean isTransparent = this.getRenderType() != RenderType.m_110451_();
        BlockElement part = this.generateSleevePart(radius, dir, false);
        BlockElement reversePart = isTransparent ? this.generateSleevePart(radius, dir, true) : null;
        IModelBuilder<?> builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, bark);
        for (Map.Entry e : part.f_111310_.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad(part, (BlockElementFace)e.getValue(), bark, face, BlockModelRotation.X0_Y0, this.modelLocation));
            if (!isTransparent) continue;
            builder.addCulledFace(face, ModelUtils.makeBakedQuad(reversePart, (BlockElementFace)e.getValue(), bark, face.m_122424_(), BlockModelRotation.X0_Y0, this.modelLocation));
        }
        return builder.build();
    }

    @Override
    public BakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite icon) {
        boolean isTransparent = this.getRenderType() != RenderType.m_110451_();
        BlockElement part = this.generateCorePart(radius, axis, false);
        BlockElement reversePart = isTransparent ? this.generateCorePart(radius, axis, true) : null;
        IModelBuilder<?> builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, icon);
        for (Map.Entry e : part.f_111310_.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad(part, (BlockElementFace)e.getValue(), icon, face, BlockModelRotation.X0_Y0, this.modelLocation));
            if (!isTransparent) continue;
            builder.addCulledFace(face, ModelUtils.makeBakedQuad(reversePart, (BlockElementFace)e.getValue(), icon, face.m_122424_(), BlockModelRotation.X0_Y0, this.modelLocation));
        }
        return builder.build();
    }

    public BakedModel bakeSleeveFace(int radius, Direction dir, TextureAtlasSprite rings) {
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.m_122429_() != 0 ? halfSize : dradius;
        int halfSizeY = dir.m_122430_() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.m_122431_() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.m_122429_() * move;
        int centerY = 16 + dir.m_122430_() * move;
        int centerZ = 16 + dir.m_122431_() * move;
        Vector3f posFrom = new Vector3f((float)(centerX - halfSizeX) / 2.0f, (float)(centerY - halfSizeY) / 2.0f, (float)(centerZ - halfSizeZ) / 2.0f);
        Vector3f posTo = new Vector3f((float)(centerX + halfSizeX) / 2.0f, (float)(centerY + halfSizeY) / 2.0f, (float)(centerZ + halfSizeZ) / 2.0f);
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
        mapFacesIn.put(dir, new BlockElementFace(dir, -1, null, uvface));
        BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
        IModelBuilder<?> builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, rings);
        for (Map.Entry e : part.f_111310_.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad(part, (BlockElementFace)e.getValue(), rings, face, BlockModelRotation.X0_Y0, this.modelLocation));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        int idx;
        int connRadius;
        if (side == null) {
            return super.getQuads(state, null, rand, extraData, renderType);
        }
        if (state == null || this.getRenderType() != RenderType.m_110451_()) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(24);
        int coreRadius = this.getRadius(state);
        if (coreRadius > 8) {
            return Collections.emptyList();
        }
        int[] connections = new int[]{0, 0, 0, 0, 0, 0};
        ModelConnections connectionsData = (ModelConnections)extraData.get(ModelConnections.CONNECTIONS_PROPERTY);
        if (connectionsData != null) {
            connections = connectionsData.getAllRadii();
        }
        if ((connRadius = connections[idx = side.m_122411_()]) > 0) {
            quadsList.addAll(this.sleeveFaces[idx][connRadius - 1].getQuads(state, side, rand, extraData, renderType));
        }
        return quadsList;
    }
}

