/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.item;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.substance.Emptiable;
import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.substance.DenudeSubstance;
import com.ferreusveritas.dynamictrees.systems.substance.DepleteSubstance;
import com.ferreusveritas.dynamictrees.systems.substance.FertilizeSubstance;
import com.ferreusveritas.dynamictrees.systems.substance.FreezeSubstance;
import com.ferreusveritas.dynamictrees.systems.substance.GrowthSubstance;
import com.ferreusveritas.dynamictrees.systems.substance.HarvestSubstance;
import com.ferreusveritas.dynamictrees.systems.substance.MegaSubstance;
import com.ferreusveritas.dynamictrees.systems.substance.TransformSubstance;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.DendroBrewingRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;

public class DendroPotion
extends Item
implements SubstanceEffectProvider,
Emptiable {
    public static final List<DendroBrewingRecipe> brewingRecipes = new ArrayList<DendroBrewingRecipe>();
    public static final String INDEX_TAG_KEY = "potion_index";
    public static final String TREE_TAG_KEY = "target";

    public DendroPotion() {
        super(new Item.Properties().m_41487_(1));
    }

    public static ItemStack applyIndexTag(ItemStack potionStack, int potionIndex) {
        potionStack.m_41784_().m_128405_(INDEX_TAG_KEY, potionIndex);
        return potionStack;
    }

    public static DendroPotionType getPotionType(ItemStack stack) {
        return DendroPotionType.values()[stack.m_41784_().m_128451_(INDEX_TAG_KEY)];
    }

    @Override
    @Nullable
    public SubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        return switch (DendroPotion.getPotionType(itemStack)) {
            default -> null;
            case DendroPotionType.BURGEONING -> new GrowthSubstance();
            case DendroPotionType.GIGAS -> new MegaSubstance();
            case DendroPotionType.DEPLETION -> new DepleteSubstance().setAmount(15);
            case DendroPotionType.FERTILITY -> new FertilizeSubstance().setAmount(15);
            case DendroPotionType.PERSISTENCE -> new FreezeSubstance();
            case DendroPotionType.TRANSFORM -> new TransformSubstance(this.getTargetSpecies(itemStack));
            case DendroPotionType.HARVEST -> new HarvestSubstance();
            case DendroPotionType.DENUDING -> new DenudeSubstance();
        };
    }

    public Species getTargetSpecies(ItemStack itemStack) {
        CompoundTag nbtTag = itemStack.m_41784_();
        return nbtTag.m_128441_(TREE_TAG_KEY) ? TreeRegistry.findSpecies(nbtTag.m_128461_(TREE_TAG_KEY)) : Species.NULL_SPECIES;
    }

    public ItemStack setTargetSpecies(ItemStack itemStack, Species species) {
        itemStack.m_41784_().m_128359_(TREE_TAG_KEY, species.getRegistryName().toString());
        return itemStack;
    }

    public void registerRecipes() {
        ItemStack baseStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potion.m_43489_((String)((String)DTConfigs.BIOCHAR_BASE_BREWING_BASE.get())));
        brewingRecipes.add(this.getRecipe(baseStack, new ItemStack((ItemLike)Items.f_42414_), this.getPotionStack(DendroPotionType.BIOCHAR)));
        for (int i = 1; i < DendroPotionType.values().length; ++i) {
            DendroPotionType type = DendroPotionType.values()[i];
            if (!type.isActive()) continue;
            brewingRecipes.add(this.getRecipe(type.getIngredient(), type));
        }
        for (Species species : TreeRegistry.getPotionTransformableSpecies()) {
            brewingRecipes.add(new DendroBrewingRecipe(this.getPotionStack(DendroPotionType.TRANSFORM), species.getSeedStack(1), this.setTargetSpecies(this.getPotionStack(DendroPotionType.TRANSFORM), species)));
        }
        brewingRecipes.forEach(BrewingRecipeRegistry::addRecipe);
    }

    private DendroBrewingRecipe getRecipe(ItemStack ingredient, DendroPotionType typeOut) {
        return this.getRecipe(this.getPotionStack(typeOut.getBasePotionType()), ingredient, this.getPotionStack(typeOut));
    }

    private DendroBrewingRecipe getRecipe(ItemStack stackIn, ItemStack ingredientStack, ItemStack stackOut) {
        return new DendroBrewingRecipe(stackIn, ingredientStack, stackOut);
    }

    private ItemStack getPotionStack(DendroPotionType type) {
        return DendroPotion.applyIndexTag(new ItemStack((ItemLike)this), type.getIndex());
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_() + "." + DendroPotion.getPotionType(stack).getName();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        DendroPotionType potionType = DendroPotion.getPotionType(stack);
        if (potionType != DendroPotionType.TRANSFORM || !this.getTargetSpecies(stack).isValid()) {
            tooltip.add(DendroPotion.getPotionType(stack).getDescription());
            return;
        }
        Species species = this.getTargetSpecies(stack);
        tooltip.add((Component)Component.m_237110_((String)"potion.transform.description", (Object[])new Object[]{species.getTextComponent()}).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY)));
    }

    public int getColor(ItemStack stack, int tint) {
        return tint == 0 ? DendroPotion.getPotionType(stack).getColor() : -1;
    }

    @Override
    public ItemStack getEmptyContainer() {
        return new ItemStack((ItemLike)Items.f_42590_);
    }

    public static enum DendroPotionType {
        BIOCHAR(0, true, "biochar", 2564892, Items.f_42414_),
        DEPLETION(1, true, "depletion", 7781997, Items.f_42518_),
        GIGAS(2, true, "gigas", 14913565, Items.f_42577_),
        BURGEONING(3, true, "burgeoning", 11124414, Items.f_42586_),
        FERTILITY(4, false, "fertility", 4903936, Items.f_42526_),
        PERSISTENCE(5, false, "persistence", 3709695, Items.f_41941_),
        TRANSFORM(6, true, "transform", 8370340, Items.f_42696_),
        HARVEST(7, false, "harvest", 15188324, Items.f_42546_),
        DENUDING(8, false, "denuding", 10780230, Items.f_42592_, 1);

        private final int index;
        private final boolean active;
        private final String name;
        private final int color;
        private final ItemStack ingredient;
        private final int baseIndex;

        private DendroPotionType(int index, boolean active, String name, int color, Item ingredient) {
            this(index, active, name, color, ingredient, 0);
        }

        private DendroPotionType(int index, boolean active, String name, int color, Item ingredient, int baseIndex) {
            this.index = index;
            this.active = active;
            this.name = name;
            this.color = color;
            this.ingredient = new ItemStack((ItemLike)ingredient);
            this.baseIndex = baseIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public ItemStack getIngredient() {
            return this.ingredient;
        }

        public Component getDescription() {
            return Component.m_237115_((String)("potion." + this.name + ".description" + (this == TRANSFORM ? ".empty" : ""))).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY));
        }

        public DendroPotionType getBasePotionType() {
            return DendroPotionType.values()[this.baseIndex];
        }
    }
}

