/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;

public final class StaticFieldDeserialiser<T>
implements JsonDeserialiser<T> {
    private final Class<T> type;

    public StaticFieldDeserialiser(Class<T> type) {
        this.type = type;
    }

    @Override
    public Result<T, JsonElement> deserialise(JsonElement jsonElement) {
        return JsonDeserialisers.STRING.deserialise(jsonElement).map(string -> Stream.of(this.type.getFields()).filter(field -> Modifier.isStatic(field.getModifiers()) && field.getName().equals(string)).findFirst().map(field -> {
            try {
                Object obj = field.get(null);
                if (this.type.isInstance(obj)) {
                    return this.type.cast(obj);
                }
            }
            catch (IllegalAccessException e) {
                LogManager.getLogger().warn("Tried to access field '" + field.getName() + "' illegally from class '" + this.type.getName() + "'.", (Throwable)e);
            }
            return null;
        }).orElse(null), "Could not get '" + this.type.getName() + "' from '{previous_value}'.");
    }
}

