/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;

public final class SoundTypeDeserialiser
implements JsonDeserialiser<SoundType> {
    private static final Map<ResourceLocation, SoundType> SOUND_TYPES = (Map)Util.m_137469_(new HashMap(), soundTypes -> {
        soundTypes.put(new ResourceLocation("wood"), SoundType.f_56736_);
        soundTypes.put(new ResourceLocation("gravel"), SoundType.f_56739_);
        soundTypes.put(new ResourceLocation("grass"), SoundType.f_56740_);
        soundTypes.put(new ResourceLocation("lily_pad"), SoundType.f_56741_);
        soundTypes.put(new ResourceLocation("stone"), SoundType.f_56742_);
        soundTypes.put(new ResourceLocation("metal"), SoundType.f_56743_);
        soundTypes.put(new ResourceLocation("glass"), SoundType.f_56744_);
        soundTypes.put(new ResourceLocation("wool"), SoundType.f_56745_);
        soundTypes.put(new ResourceLocation("sand"), SoundType.f_56746_);
        soundTypes.put(new ResourceLocation("snow"), SoundType.f_56747_);
        soundTypes.put(new ResourceLocation("ladder"), SoundType.f_56748_);
        soundTypes.put(new ResourceLocation("anvil"), SoundType.f_56749_);
        soundTypes.put(new ResourceLocation("slime_block"), SoundType.f_56750_);
        soundTypes.put(new ResourceLocation("honey_block"), SoundType.f_56751_);
        soundTypes.put(new ResourceLocation("wet_grass"), SoundType.f_56752_);
        soundTypes.put(new ResourceLocation("coral_block"), SoundType.f_56753_);
        soundTypes.put(new ResourceLocation("bamboo"), SoundType.f_56754_);
        soundTypes.put(new ResourceLocation("bamboo_sapling"), SoundType.f_56755_);
        soundTypes.put(new ResourceLocation("scaffolding"), SoundType.f_56756_);
        soundTypes.put(new ResourceLocation("sweet_berry_bush"), SoundType.f_56757_);
        soundTypes.put(new ResourceLocation("crop"), SoundType.f_56758_);
        soundTypes.put(new ResourceLocation("hard_crop"), SoundType.f_56759_);
        soundTypes.put(new ResourceLocation("vine"), SoundType.f_56760_);
        soundTypes.put(new ResourceLocation("nether_wart"), SoundType.f_56761_);
        soundTypes.put(new ResourceLocation("lantern"), SoundType.f_56762_);
        soundTypes.put(new ResourceLocation("stem"), SoundType.f_56763_);
        soundTypes.put(new ResourceLocation("nylium"), SoundType.f_56710_);
        soundTypes.put(new ResourceLocation("fungus"), SoundType.f_56711_);
        soundTypes.put(new ResourceLocation("roots"), SoundType.f_56712_);
        soundTypes.put(new ResourceLocation("shroomlight"), SoundType.f_56713_);
        soundTypes.put(new ResourceLocation("weeping_vines"), SoundType.f_56714_);
        soundTypes.put(new ResourceLocation("twisting_vines"), SoundType.f_56715_);
        soundTypes.put(new ResourceLocation("soul_sand"), SoundType.f_56716_);
        soundTypes.put(new ResourceLocation("soul_soil"), SoundType.f_56717_);
        soundTypes.put(new ResourceLocation("basalt"), SoundType.f_56718_);
        soundTypes.put(new ResourceLocation("wart_block"), SoundType.f_56719_);
        soundTypes.put(new ResourceLocation("netherrack"), SoundType.f_56720_);
        soundTypes.put(new ResourceLocation("nether_bricks"), SoundType.f_56721_);
        soundTypes.put(new ResourceLocation("nether_sprouts"), SoundType.f_56722_);
        soundTypes.put(new ResourceLocation("nether_ore"), SoundType.f_56723_);
        soundTypes.put(new ResourceLocation("bone_block"), SoundType.f_56724_);
        soundTypes.put(new ResourceLocation("netherite_block"), SoundType.f_56725_);
        soundTypes.put(new ResourceLocation("ancient_debris"), SoundType.f_56726_);
        soundTypes.put(new ResourceLocation("lodestone"), SoundType.f_56727_);
        soundTypes.put(new ResourceLocation("chain"), SoundType.f_56728_);
        soundTypes.put(new ResourceLocation("nether_gold_ore"), SoundType.f_56729_);
        soundTypes.put(new ResourceLocation("gilded_blackstone"), SoundType.f_56730_);
        soundTypes.put(new ResourceLocation("candle"), SoundType.f_154653_);
        soundTypes.put(new ResourceLocation("amethyst"), SoundType.f_154654_);
        soundTypes.put(new ResourceLocation("amethyst_cluster"), SoundType.f_154655_);
        soundTypes.put(new ResourceLocation("small_amethyst_bud"), SoundType.f_154656_);
        soundTypes.put(new ResourceLocation("medium_amethyst_bud"), SoundType.f_154657_);
        soundTypes.put(new ResourceLocation("large_amethyst_bud"), SoundType.f_154658_);
        soundTypes.put(new ResourceLocation("tuff"), SoundType.f_154659_);
        soundTypes.put(new ResourceLocation("calcite"), SoundType.f_154660_);
        soundTypes.put(new ResourceLocation("dripstone_block"), SoundType.f_154661_);
        soundTypes.put(new ResourceLocation("pointed_dripstone"), SoundType.f_154662_);
        soundTypes.put(new ResourceLocation("copper"), SoundType.f_154663_);
        soundTypes.put(new ResourceLocation("cave_vines"), SoundType.f_154664_);
        soundTypes.put(new ResourceLocation("spore_blossom"), SoundType.f_154665_);
        soundTypes.put(new ResourceLocation("azalea"), SoundType.f_154666_);
        soundTypes.put(new ResourceLocation("flowering_azalea"), SoundType.f_154667_);
        soundTypes.put(new ResourceLocation("moss_carpet"), SoundType.f_154668_);
        soundTypes.put(new ResourceLocation("moss"), SoundType.f_154669_);
        soundTypes.put(new ResourceLocation("big_dripleaf"), SoundType.f_154670_);
        soundTypes.put(new ResourceLocation("small_dripleaf"), SoundType.f_154671_);
        soundTypes.put(new ResourceLocation("rooted_dirt"), SoundType.f_154672_);
        soundTypes.put(new ResourceLocation("hanging_roots"), SoundType.f_154673_);
        soundTypes.put(new ResourceLocation("azalea_leaves"), SoundType.f_154674_);
        soundTypes.put(new ResourceLocation("sculk_sensor"), SoundType.f_154675_);
        soundTypes.put(new ResourceLocation("glow_lichen"), SoundType.f_154676_);
        soundTypes.put(new ResourceLocation("deepslate"), SoundType.f_154677_);
        soundTypes.put(new ResourceLocation("deepslate_bricks"), SoundType.f_154678_);
        soundTypes.put(new ResourceLocation("deepslate_tiles"), SoundType.f_154679_);
        soundTypes.put(new ResourceLocation("polished_deepslate"), SoundType.f_154680_);
    });

    public static void registerSoundType(ResourceLocation name, SoundType soundType) {
        SOUND_TYPES.putIfAbsent(name, soundType);
    }

    @Override
    public Result<SoundType, JsonElement> deserialise(JsonElement input) {
        return JsonDeserialisers.RESOURCE_LOCATION.deserialise(input).map(SOUND_TYPES::get, "Could not get sound type from \"{}\".");
    }
}

