/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public final class ListDeserialiser<T>
implements JsonDeserialiser<List<T>> {
    private final JsonDeserialiser<T> thisGetter;
    private final Supplier<List<T>> listSupplier;

    public ListDeserialiser(JsonDeserialiser<T> thisGetter) {
        this(thisGetter, LinkedList::new);
    }

    public ListDeserialiser(JsonDeserialiser<T> thisGetter, Supplier<List<T>> listSupplier) {
        this.thisGetter = thisGetter;
        this.listSupplier = listSupplier;
    }

    @Override
    public Result<List<T>, JsonElement> deserialise(JsonElement jsonElement) {
        return JsonDeserialisers.JSON_ARRAY.deserialise(jsonElement).map(array -> {
            List<T> getterList = this.listSupplier.get();
            array.forEach(elem -> this.thisGetter.deserialise(elem).ifSuccess(getterList::add));
            return getterList;
        });
    }

    public static <T> Class<List<T>> getListClass(Class<T> c) {
        return ListDeserialiser.getListClass(c, LinkedList::new);
    }

    public static <T> Class<List<T>> getListClass(Class<T> c, Supplier<List<T>> listSupplier) {
        List<T> instance = listSupplier.get();
        return instance.getClass();
    }
}

