/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.ferreusveritas.dynamictrees.util.ThrowableRunnable;
import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class SubCommand {
    protected static final DynamicCommandExceptionType NO_TREE_FOUND = new DynamicCommandExceptionType(pos -> Component.m_237110_((String)"commands.dynamictrees.error.get_tree", (Object[])new Object[]{Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{SubCommand.getVector3i(pos).m_123341_(), SubCommand.getVector3i(pos).m_123342_(), SubCommand.getVector3i(pos).m_123343_()}).m_130938_(style -> style.m_131140_(ChatFormatting.DARK_RED))}));
    protected static final DynamicCommandExceptionType SPECIES_UNKNOWN = new DynamicCommandExceptionType(resLocStr -> Component.m_237110_((String)"commands.dynamictrees.error.unknown_species", (Object[])new Object[]{SubCommand.darkRed(resLocStr)}));
    protected static final DynamicCommandExceptionType SPECIES_NOT_TRANSFORMABLE = new DynamicCommandExceptionType(nonTransformableSpecies -> Component.m_237110_((String)"commands.dynamictrees.error.not_transformable", (Object[])new Object[]{SubCommand.darkRed(nonTransformableSpecies)}));

    private static Vec3i getVector3i(Object vecObj) {
        if (vecObj instanceof Vec3i) {
            return (Vec3i)vecObj;
        }
        return Vec3i.f_123288_;
    }

    protected abstract String getName();

    protected abstract int getPermissionLevel();

    public ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder argumentBuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)this.getName()).requires(commandSource -> commandSource.m_6761_(this.getPermissionLevel()));
        this.registerArguments().forEach(arg_0 -> ((LiteralArgumentBuilder)argumentBuilder).then(arg_0));
        return argumentBuilder;
    }

    protected List<ArgumentBuilder<CommandSourceStack, ?>> registerArguments() {
        return Lists.newArrayList((Object[])new ArgumentBuilder[]{this.registerArgument()});
    }

    public abstract ArgumentBuilder<CommandSourceStack, ?> registerArgument();

    protected static int executesSuccess(ThrowableRunnable<CommandSyntaxException> executeRunnable) throws CommandSyntaxException {
        executeRunnable.run();
        return 1;
    }

    protected static int executesSuccess(CommandContext<CommandSourceStack> context, Consumer<CommandContext<CommandSourceStack>> executeConsumer) {
        executeConsumer.accept(context);
        return 1;
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, Boolean> booleanArgument(String name) {
        return Commands.m_82129_((String)name, (ArgumentType)BoolArgumentType.bool());
    }

    protected static boolean booleanArgument(CommandContext<CommandSourceStack> context, String name) {
        return BoolArgumentType.getBool(context, (String)name);
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, Integer> intArgument(String name) {
        return Commands.m_82129_((String)name, (ArgumentType)IntegerArgumentType.integer());
    }

    protected static int intArgument(CommandContext<CommandSourceStack> context, String name) {
        return IntegerArgumentType.getInteger(context, (String)name);
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, String> stringArgument(String name) {
        return Commands.m_82129_((String)name, (ArgumentType)StringArgumentType.string());
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, String> stringArgument(String name, Collection<String> suggestions) {
        return Commands.m_82129_((String)name, (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)suggestions, (SuggestionsBuilder)builder));
    }

    protected static String stringArgument(CommandContext<CommandSourceStack> context, String name) {
        return StringArgumentType.getString(context, (String)name);
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, Coordinates> blockPosArgument() {
        return Commands.m_82129_((String)"location", (ArgumentType)BlockPosArgument.m_118239_());
    }

    protected static BlockPos blockPosArgument(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return BlockPosArgument.m_118242_(context, (String)"location");
    }

    protected static BlockPos rootPosArgument(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = SubCommand.blockPosArgument(context);
        BlockPos rootPos = TreeHelper.findRootNode((Level)((CommandSourceStack)context.getSource()).m_81372_(), pos);
        if (rootPos == BlockPos.f_121853_) {
            throw NO_TREE_FOUND.create((Object)pos);
        }
        return rootPos;
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> speciesArgument() {
        return SubCommand.resourceLocationArgument("species", Species.REGISTRY::getRegistryNames);
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> transformableSpeciesArgument() {
        return SubCommand.resourceLocationArgument("species", TreeRegistry::getTransformableSpeciesLocations);
    }

    protected static Species speciesArgument(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation registryName = ResourceLocationArgument.m_107011_(context, (String)"species");
        Species species = TreeRegistry.findSpecies(registryName);
        if (!species.isValid()) {
            throw SPECIES_UNKNOWN.create((Object)registryName.toString());
        }
        return species;
    }

    protected static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> resourceLocationArgument(String name, Supplier<Collection<ResourceLocation>> suggestionsSupplier) {
        return Commands.m_82129_((String)name, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)((Iterable)suggestionsSupplier.get()), (SuggestionsBuilder)builder));
    }

    protected static Component aqua(Object object) {
        return CommandHelper.colour(object, ChatFormatting.AQUA);
    }

    protected static Component darkRed(Object object) {
        return CommandHelper.colour(object, ChatFormatting.DARK_RED);
    }

    protected static void sendSuccess(CommandSourceStack source, Component component) {
        source.m_288197_(() -> component.m_6881_().m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)), false);
    }

    protected static void sendSuccessAndLog(CommandSourceStack source, Component component) {
        source.m_288197_(() -> component.m_6881_().m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)), true);
    }

    protected static void sendFailure(CommandSourceStack source, Component component) {
        source.m_81352_((Component)component.m_6881_().m_130938_(style -> style.m_131140_(ChatFormatting.RED)));
    }
}

