/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.rooty;

import com.ferreusveritas.dynamictrees.api.RootyBlockDecayer;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.BlockWithDynamicHardness;
import com.ferreusveritas.dynamictrees.block.branch.BasicRootsBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.entity.SpeciesBlockEntity;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class RootyBlock
extends BlockWithDynamicHardness
implements TreePart,
EntityBlock,
BonemealableBlock {
    public static RootyBlockDecayer rootyBlockDecayer = null;
    public static final IntegerProperty FERTILITY = IntegerProperty.m_61631_((String)"fertility", (int)0, (int)15);
    public static final BooleanProperty IS_VARIANT = BooleanProperty.m_61465_((String)"is_variant");
    private final SoilProperties properties;

    public RootyBlock(SoilProperties properties, BlockBehaviour.Properties blockProperties) {
        super(blockProperties.m_60977_().m_278166_(PushReaction.BLOCK));
        this.properties = properties;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FERTILITY, (Comparable)Integer.valueOf(0))).m_61124_((Property)IS_VARIANT, (Comparable)Boolean.valueOf(false)));
    }

    public SoilProperties getSoilProperties() {
        return this.properties;
    }

    public Block getPrimitiveSoilBlock() {
        return this.getSoilProperties().getPrimitiveSoilBlock();
    }

    public BlockState getPrimitiveSoilState(BlockState currentSoilState) {
        return this.getSoilProperties().getPrimitiveSoilState(currentSoilState);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @javax.annotation.Nullable Entity entity) {
        return this.getPrimitiveSoilBlock().getSoundType(this.getPrimitiveSoilState(state), level, pos, entity);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getPrimitiveSoilBlock().getLightEmission(this.getPrimitiveSoilState(state), level, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getPrimitiveSoilBlock().m_7420_(this.getPrimitiveSoilState(state), level, pos);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getPrimitiveSoilBlock().m_7753_(this.getPrimitiveSoilState(state), level, pos);
    }

    public MapColor m_284356_() {
        return this.getPrimitiveSoilBlock().m_284356_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getPrimitiveSoilBlock().m_5940_(this.getPrimitiveSoilState(state), level, pos, context);
    }

    public float m_49958_() {
        return this.getPrimitiveSoilBlock().m_49958_();
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getPrimitiveSoilBlock().getExplosionResistance(this.getPrimitiveSoilState(state), level, pos, explosion);
    }

    public float m_49961_() {
        return this.getPrimitiveSoilBlock().m_49961_();
    }

    public float m_49964_() {
        return this.getPrimitiveSoilBlock().m_49964_();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getPrimitiveSoilBlock().getFireSpreadSpeed(this.getPrimitiveSoilState(state), level, pos, face);
    }

    public boolean isFireSource(BlockState state, LevelReader level, BlockPos pos, Direction side) {
        return this.getPrimitiveSoilBlock().isFireSource(this.getPrimitiveSoilState(state), level, pos, side);
    }

    @Nonnull
    public List<ItemStack> m_49635_(@Nonnull BlockState state, @Nonnull LootParams.Builder builder) {
        return this.getPrimitiveSoilState(state).m_287290_(builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getPrimitiveSoilBlock().getCloneItemStack(this.getPrimitiveSoilState(state), target, level, pos, player);
    }

    @Override
    public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
        return (float)((double)this.getPrimitiveSoilState(state).m_60800_(level, pos) * (Double)DTConfigs.ROOTY_BLOCK_HARDNESS_MULTIPLIER.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FERTILITY}).m_61104_(new Property[]{IS_VARIANT});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.m_61143_((Property)IS_VARIANT)).booleanValue()) {
            return new SpeciesBlockEntity(pPos, pState);
        }
        return null;
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.m_61143_((Property)IS_VARIANT);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(((Integer)DTConfigs.TREE_GROWTH_FOLDING.get()).intValue()) == 0) {
            this.updateTree(state, (Level)level, pos, random, true);
        }
    }

    public Direction getTrunkDirection(BlockGetter access, BlockPos rootPos) {
        return Direction.UP;
    }

    public void updateTree(BlockState rootyState, Level level, BlockPos rootPos, RandomSource random, boolean natural) {
        if (CoordUtils.isSurroundedByLoadedChunks(level, rootPos)) {
            BlockPos treePos;
            TreePart treeBase;
            boolean viable = false;
            Species species = this.getSpecies(rootyState, (LevelAccessor)level, rootPos);
            if (species.isValid() && (treeBase = TreeHelper.getTreePart(level.m_8055_(treePos = rootPos.m_121945_(this.getTrunkDirection((BlockGetter)level, rootPos))))) != TreeHelper.NULL_TREE_PART) {
                viable = species.update(level, this, rootPos, this.getFertility(rootyState, (BlockGetter)level, rootPos), treeBase, treePos, random, natural);
            }
            if (!viable) {
                level.m_7731_(rootPos, this.getDecayBlockState(rootyState, (BlockGetter)level, rootPos), 3);
            }
        }
    }

    public BlockState getDecayBlockState(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getPrimitiveSoilState(state);
    }

    public void doDecay(Level level, BlockPos rootPos, BlockState rootyState, Species species) {
        if (level.f_46443_ || !TreeHelper.isRooty(rootyState)) {
            return;
        }
        this.updateTree(rootyState, level, rootPos, level.f_46441_, true);
        BlockState newState = level.m_8055_(rootPos);
        if (TreeHelper.isRooty(newState) || rootyBlockDecayer != null && rootyBlockDecayer.decay(level, rootPos, rootyState, species)) {
            return;
        }
        BlockState primitiveDirt = this.getDecayBlockState(rootyState, (BlockGetter)level, rootPos);
        level.m_7731_(rootPos, primitiveDirt, 3);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getFertility(blockState, (BlockGetter)level, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.m_21120_(hand);
        return this.getFamily(state, (BlockGetter)level, pos).onTreeActivated(new Family.TreeActivationContext(level, TreeHelper.findRootNode(level, pos), pos, state, player, hand, heldItem, hitResult)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public void destroyTree(Level level, BlockPos rootPos) {
        this.destroyTree(level, rootPos, null);
    }

    public void destroyTree(Level level, BlockPos rootPos, @javax.annotation.Nullable Player player) {
        Optional<BranchBlock> branch = TreeHelper.getBranchOpt(level.m_8055_(rootPos.m_7494_()));
        if (branch.isPresent()) {
            BranchDestructionData destroyData = branch.get().destroyBranchFromNode(level, rootPos.m_7494_(), Direction.DOWN, true, null);
            FallingTreeEntity.dropTree(level, destroyData, new ArrayList<ItemStack>(0), FallingTreeEntity.DestroyType.ROOT);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.getSpecies(state, (LevelAccessor)level, pos).soilDestroyAction(level, pos, state, player)) {
            this.m_142387_(level, player, pos, state);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_5707_(Level level, @Nonnull BlockPos rootPos, BlockState state, @Nonnull Player player) {
        this.destroyTree(level, rootPos, player);
        super.m_5707_(level, rootPos, state, player);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.destroyTree(level, pos);
        super.onBlockExploded(state, level, pos, explosion);
    }

    public int updateRadius(LevelAccessor level, BlockState state, BlockPos pos, int flags, boolean force) {
        return this.getRadius(state);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        if (pLevel instanceof Level) {
            Level level = (Level)pLevel;
            return this.getSpecies(pState, (LevelAccessor)level, pPos).canBoneMealTree();
        }
        return false;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        Species species = this.getSpecies(pState, (LevelAccessor)pLevel, pPos);
        if (species.isValid()) {
            species.applySubstance((Level)pLevel, pPos, pPos, null, null, new ItemStack((ItemLike)Items.f_42499_));
        }
    }

    public int getFertility(BlockState blockState, BlockGetter blockAccess, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)FERTILITY);
    }

    public void setFertility(Level level, BlockPos rootPos, int fertility) {
        BlockState currentState = level.m_8055_(rootPos);
        Species species = this.getSpecies(currentState, (LevelAccessor)level, rootPos);
        level.m_7731_(rootPos, (BlockState)currentState.m_61124_((Property)FERTILITY, (Comparable)Integer.valueOf(Mth.m_14045_((int)fertility, (int)0, (int)15))), 3);
        level.m_46672_(rootPos, (Block)this);
        this.setSpecies(level, rootPos, species);
    }

    public boolean fertilize(Level level, BlockPos pos, int amount) {
        int fertility = this.getFertility(level.m_8055_(pos), (BlockGetter)level, pos);
        if (fertility == 0 && amount < 0 || fertility == 15 && amount > 0) {
            return false;
        }
        this.setFertility(level, pos, fertility + amount);
        return true;
    }

    @Override
    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesTree) {
        return CellNull.NULL_CELL;
    }

    @Override
    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    @Override
    public int getRadius(BlockState state) {
        return 8;
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return 8;
    }

    @Override
    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return 0;
    }

    public MapSignal startAnalysis(LevelAccessor level, BlockPos rootPos, MapSignal signal) {
        Direction dir = this.getTrunkDirection((BlockGetter)level, rootPos);
        BlockPos treePos = rootPos.m_121945_(dir);
        BlockState treeState = level.m_8055_(treePos);
        TreeHelper.getTreePart(treeState).analyse(treeState, level, treePos, null, signal);
        return signal;
    }

    @Override
    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    public MapSignal analyse(BlockState state, LevelAccessor level, BlockPos pos, @javax.annotation.Nullable Direction fromDir, MapSignal signal) {
        signal.run(state, level, pos, fromDir);
        if (signal.root == null) {
            signal.root = pos;
        } else {
            signal.multiroot = true;
        }
        signal.foundRoot = true;
        return signal;
    }

    @Override
    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        Direction supportDir = branch instanceof BasicRootsBlock ? Direction.UP : Direction.DOWN;
        return dir == supportDir ? BranchBlock.setSupport(1, 1) : 0;
    }

    @Override
    public Family getFamily(BlockState state, BlockGetter level, BlockPos rootPos) {
        BlockPos treePos = rootPos.m_121945_(this.getTrunkDirection(level, rootPos));
        BlockState treeState = level.m_8055_(treePos);
        return TreeHelper.isBranch(treeState) ? TreeHelper.getBranch(treeState).getFamily(treeState, level, treePos) : Family.NULL_FAMILY;
    }

    @javax.annotation.Nullable
    private SpeciesBlockEntity getTileEntitySpecies(LevelAccessor level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return null;
        }
        return blockEntity instanceof SpeciesBlockEntity ? (SpeciesBlockEntity)blockEntity : null;
    }

    public Species getSpecies(BlockState state, LevelAccessor level, BlockPos rootPos) {
        Species species;
        Family tree = this.getFamily(state, (BlockGetter)level, rootPos);
        SpeciesBlockEntity rootyDirtTE = this.getTileEntitySpecies(level, rootPos);
        if (rootyDirtTE != null && (species = rootyDirtTE.getSpecies()).getFamily() == tree) {
            return rootyDirtTE.getSpecies();
        }
        return tree.getSpeciesForLocation(level, rootPos.m_121945_(this.getTrunkDirection((BlockGetter)level, rootPos)));
    }

    public void setSpecies(Level level, BlockPos rootPos, Species species) {
        SpeciesBlockEntity rootyDirtTE = this.getTileEntitySpecies((LevelAccessor)level, rootPos);
        if (rootyDirtTE != null) {
            rootyDirtTE.setSpecies(species);
        }
    }

    @Override
    public final TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.ROOT;
    }

    @Override
    public final boolean isRootNode() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int colorMultiplier(BlockColors blockColors, BlockState state, @javax.annotation.Nullable BlockAndTintGetter level, @javax.annotation.Nullable BlockPos pos, int tintIndex) {
        int white = -1;
        if (tintIndex == this.getSoilProperties().foliageTintIndex) {
            return blockColors.m_92577_(this.getPrimitiveSoilState(state), level, pos, tintIndex);
        }
        if (tintIndex == this.getSoilProperties().rootsTintIndex) {
            return state.m_60734_() instanceof RootyBlock ? this.rootColor(state, (BlockGetter)level, pos) : -1;
        }
        return -1;
    }

    public boolean getColorFromBark() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int rootColor(BlockState state, BlockGetter blockAccess, BlockPos pos) {
        return this.getFamily(state, blockAccess, pos).getRootColor(state, this.getColorFromBark());
    }

    public boolean fallWithTree(BlockState state, Level level, BlockPos pos, boolean hasRoots) {
        return this.fallWithTree(state, level, pos);
    }

    public boolean fallWithTree(BlockState state, Level level, BlockPos pos) {
        return false;
    }
}

