/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LocalNode {
    public static final String NODES = "nodes";
    public static final String ID = "id";
    public static final String OTHER = "other";
    public static final String TYPE = "type";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    private final BlockEntity entity;
    private final int index;
    private final int otherIndex;
    private final WireType type;
    private Vec3i relativePos;
    private boolean invalid = false;

    public LocalNode(BlockEntity entity, int index, int other, WireType type, BlockPos position) {
        this.entity = entity;
        this.index = index;
        this.otherIndex = other;
        this.type = type;
        this.relativePos = position.m_121996_((Vec3i)entity.m_58899_());
    }

    public LocalNode(BlockEntity entity, CompoundTag tag) {
        this.entity = entity;
        this.index = tag.m_128451_(ID);
        this.otherIndex = tag.m_128451_(OTHER);
        this.type = WireType.fromIndex(tag.m_128451_(TYPE));
        this.relativePos = new Vec3i(tag.m_128451_(X), tag.m_128451_(Y), tag.m_128451_(Z));
    }

    public void write(CompoundTag tag) {
        tag.m_128405_(ID, this.index);
        tag.m_128405_(OTHER, this.otherIndex);
        tag.m_128405_(TYPE, this.type.getIndex());
        tag.m_128405_(X, this.relativePos.m_123341_());
        tag.m_128405_(Y, this.relativePos.m_123342_());
        tag.m_128405_(Z, this.relativePos.m_123343_());
    }

    public void updateRelative(NodeRotation rotation) {
        this.relativePos = rotation.updateRelative(this.relativePos);
    }

    public int getIndex() {
        return this.index;
    }

    public int getOtherIndex() {
        return this.otherIndex;
    }

    public WireType getType() {
        return this.type;
    }

    public Vec3i getRelativePos() {
        return this.relativePos;
    }

    public BlockPos getPos() {
        return this.entity.m_58899_().m_121955_(this.relativePos);
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void invalid() {
        this.invalid = true;
    }
}

