/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.item.wearable.pocketpiston.client;

import artifacts.extensions.pocketpiston.LivingEntityExtensions;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements LivingEntityExtensions {
    @Unique
    private static final int RETRACTION_DURATION = 2;
    @Unique
    private static final int RETRACTION_DELAY = 4;
    @Shadow
    public int f_20913_;
    @Unique
    private float pocketPistonLength;
    @Unique
    private int pocketPistonTimeRemaining;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void updatePocketPistonLength(CallbackInfo ci) {
        if (this.f_20913_ != 0) {
            this.pocketPistonTimeRemaining = 6;
        }
        if (this.pocketPistonTimeRemaining > 0) {
            --this.pocketPistonTimeRemaining;
        }
        float d = (this.pocketPistonTimeRemaining < 2 ? -1.0f : 1.0f) / 2.0f;
        this.pocketPistonLength = Math.max(0.0f, Math.min(1.0f, this.pocketPistonLength + d));
    }

    @Override
    @Unique
    public float artifacts$getPocketPistonLength() {
        Minecraft minecraft = Minecraft.m_91087_();
        float partialTick = minecraft.m_91104_() ? 0.0f : minecraft.m_91296_();
        float d = ((float)this.pocketPistonTimeRemaining + partialTick - 1.0f < 2.0f ? -1.0f : 1.0f) / 2.0f;
        return Math.max(0.0f, Math.min(1.0f, this.pocketPistonLength + d * partialTick));
    }
}

