/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.winding_machine;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGRegistries;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.base.ElectricPlacementPacket;
import com.drmangotea.tfmg.content.electricity.connection.cable_type.CableType;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnection;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnectorBlockEntity;
import com.drmangotea.tfmg.content.machinery.misc.winding_machine.WindingMachineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class SpoolItem
extends Item {
    public final int barColor;
    public final ResourceLocation cableTypeKey;

    public SpoolItem(Item.Properties properties, int barColor, ResourceLocation type) {
        super(properties);
        this.barColor = barColor;
        this.cableTypeKey = type;
    }

    public void m_7836_(ItemStack stack, Level p_41448_, Player p_41449_) {
        stack.m_41784_().m_128405_("Amount", 1000);
        super.m_7836_(stack, p_41448_, p_41449_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && stack.m_41784_().m_128454_("Position") != 0L) {
            BlockEntity blockEntity = level.m_7702_(BlockPos.m_122022_((long)stack.m_41784_().m_128454_("Position")));
            if (blockEntity instanceof CableConnectorBlockEntity) {
                CableConnectorBlockEntity be = (CableConnectorBlockEntity)blockEntity;
                be.player = null;
            }
            stack.m_41784_().m_128356_("Position", 0L);
            stack.m_41784_().m_128473_("Position");
            stack.m_41784_().m_128473_("XPos");
            stack.m_41784_().m_128473_("YPos");
            stack.m_41784_().m_128473_("ZPos");
            if (level.f_46443_) {
                player.m_5661_((Component)CreateLang.translateDirect((String)"wires.removed_data", (Object[])new Object[0]).m_130940_(ChatFormatting.YELLOW), true);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)CreateLang.translateDirect((String)"tooltip.coils", (Object[])new Object[]{stack.m_41784_().m_128451_("Amount")}).m_130940_(ChatFormatting.GREEN));
        BlockPos pos = BlockPos.m_122022_((long)stack.m_41784_().m_128454_("Position"));
        if (pos.m_121878_() != 0L) {
            tooltip.add((Component)CreateLang.text((String)(pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_())).component().m_130940_(ChatFormatting.AQUA));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity posToConnect;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (Objects.equals(this.cableTypeKey, TFMG.asResource("empty"))) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CableConnectorBlockEntity) {
            CableConnectorBlockEntity be = (CableConnectorBlockEntity)blockEntity;
            if (stack.m_41784_().m_128454_("Position") != 0L) {
                posToConnect = BlockPos.m_122022_((long)stack.m_41784_().m_128454_("Position"));
                if (posToConnect.equals((Object)pos)) {
                    stack.m_41784_().m_128356_("Position", 0L);
                    if (level.f_46443_) {
                        player.m_5661_((Component)CreateLang.translateDirect((String)"wires.cant_connect_itself", (Object[])new Object[0]).m_130940_(ChatFormatting.YELLOW), true);
                    }
                    be.player = null;
                    be.sendData();
                    be.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                BlockEntity blockEntity2 = level.m_7702_((BlockPos)posToConnect);
                if (blockEntity2 instanceof CableConnectorBlockEntity) {
                    CableConnectorBlockEntity otherBE = (CableConnectorBlockEntity)blockEntity2;
                    CableType cableType = TFMGUtils.getCableType(this.cableTypeKey);
                    CableConnection connection1 = new CableConnection(be.getCablePosition(), otherBE.getCablePosition(), otherBE.m_58899_(), cableType, true);
                    CableConnection connection2 = new CableConnection(otherBE.getCablePosition(), be.getCablePosition(), be.m_58899_(), cableType, false);
                    float wireCost = connection1.getLength() / 8.0f;
                    if ((float)stack.m_41784_().m_128451_("Amount") < wireCost * 125.0f) {
                        return InteractionResult.PASS;
                    }
                    if (be.connections.contains(connection1) || otherBE.connections.contains(connection1)) {
                        if (level.f_46443_) {
                            player.m_5661_((Component)CreateLang.translateDirect((String)"wires.connection_already_created", (Object[])new Object[0]).m_130940_(ChatFormatting.YELLOW), true);
                        }
                        be.player = null;
                        be.sendData();
                        be.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                    be.connections.add(connection1);
                    otherBE.connections.add(connection2);
                    if (!level.f_46443_) {
                        TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new ElectricPlacementPacket(BlockPos.m_122022_((long)be.getPos())));
                    }
                    be.onPlaced();
                    if (!level.f_46443_) {
                        TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new ElectricPlacementPacket(BlockPos.m_122022_((long)otherBE.getPos())));
                    }
                    otherBE.onPlaced();
                    stack.m_41784_().m_128405_("Amount", (int)((float)stack.m_41784_().m_128451_("Amount") - wireCost * 125.0f));
                    be.player = null;
                    otherBE.player = null;
                    be.m_6596_();
                    otherBE.m_6596_();
                    be.sendData();
                    otherBE.sendData();
                    stack.m_41784_().m_128473_("Position");
                    stack.m_41784_().m_128473_("XPos");
                    stack.m_41784_().m_128473_("YPos");
                    stack.m_41784_().m_128473_("ZPos");
                }
                be.player = null;
                return InteractionResult.SUCCESS;
            }
            stack.m_41784_().m_128356_("Position", be.m_58899_().m_121878_());
            stack.m_41784_().m_128347_("XPos", be.getCablePosition().m_7096_());
            stack.m_41784_().m_128347_("YPos", be.getCablePosition().m_7098_());
            stack.m_41784_().m_128347_("ZPos", be.getCablePosition().m_7094_());
            be.player = player;
            be.color = this.barColor;
            be.sendData();
            be.m_6596_();
            return InteractionResult.SUCCESS;
        }
        posToConnect = level.m_7702_(pos);
        if (posToConnect instanceof WindingMachineBlockEntity) {
            WindingMachineBlockEntity be = (WindingMachineBlockEntity)posToConnect;
            ItemStack oldSpool = ItemStack.f_41583_;
            if (!be.spool.m_41619_()) {
                oldSpool = be.spool;
            }
            be.spool = context.m_43722_();
            context.m_43723_().m_21008_(context.m_43724_(), oldSpool);
            be.sendData();
            be.m_6596_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void removeOtherConnections(Player player, ItemStack stack) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = player.m_150109_().m_8020_(i);
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean p_41408_) {
        super.m_6883_(stack, level, entity, slot, p_41408_);
        if (stack.m_41784_().m_128451_("Amount") == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            if (!stack.m_150930_((Item)TFMGItems.EMPTY_SPOOL.get())) {
                player.m_150109_().m_6836_(slot, TFMGItems.EMPTY_SPOOL.asStack());
            }
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return !Objects.equals(this.cableTypeKey, TFMG.asResource("empty")) && TFMGRegistries.registeredCableTypes.containsKey(this.cableTypeKey);
    }

    public int m_142159_(ItemStack stack) {
        return this.barColor;
    }

    public int m_142158_(ItemStack stack) {
        return (int)(13.0f * ((float)stack.m_41784_().m_128451_("Amount") / 1000.0f));
    }
}

