/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.base;

import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.function.Consumer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class EngineFluidTank
extends SmartFluidTank {
    final boolean extractionAllowed;
    final boolean insertionAllowed;
    final TagKey<Fluid> allowedFluids;
    final TagKey<Fluid> fluidBlacklist;

    public EngineFluidTank(int capacity, boolean extractionAllowed, boolean insertionAllowed, Consumer<FluidStack> updateCallback) {
        super(capacity, updateCallback);
        this.extractionAllowed = extractionAllowed;
        this.insertionAllowed = insertionAllowed;
        this.allowedFluids = null;
        this.fluidBlacklist = null;
    }

    public EngineFluidTank(int capacity, boolean extractionAllowed, boolean insertionAllowed, TagKey<Fluid> allowedFluid, Consumer<FluidStack> updateCallback) {
        super(capacity, updateCallback);
        this.extractionAllowed = extractionAllowed;
        this.insertionAllowed = insertionAllowed;
        this.allowedFluids = allowedFluid;
        this.fluidBlacklist = null;
    }

    public EngineFluidTank(int capacity, boolean extractionAllowed, boolean insertionAllowed, Consumer<FluidStack> updateCallback, TagKey<Fluid> fluidBlacklist) {
        super(capacity, updateCallback);
        this.extractionAllowed = extractionAllowed;
        this.insertionAllowed = insertionAllowed;
        this.allowedFluids = null;
        this.fluidBlacklist = fluidBlacklist;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.extractionAllowed) {
            return FluidStack.EMPTY;
        }
        return super.drain(resource, action);
    }

    public FluidStack forceDrain(FluidStack resource, IFluidHandler.FluidAction action) {
        return super.drain(resource, action);
    }

    public FluidStack forceDrain(int resource, IFluidHandler.FluidAction action) {
        return super.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.extractionAllowed) {
            return FluidStack.EMPTY;
        }
        return super.drain(maxDrain, action);
    }

    public int forceFill(FluidStack resource, IFluidHandler.FluidAction action) {
        return super.fill(resource, action);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fluidBlacklist != null && resource.getFluid().m_205067_(this.fluidBlacklist)) {
            return 0;
        }
        if (this.allowedFluids != null && !resource.getFluid().m_205067_(this.allowedFluids)) {
            return 0;
        }
        if (!this.insertionAllowed) {
            return 0;
        }
        return super.fill(resource, action);
    }
}

