/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components;

import com.google.gson.JsonObject;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerRecipe;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerRecipeOutput;
import com.oierbravo.create_mechanical_spawner.registrate.ModRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.Nullable;

public class SpawnerRecipeBuilder {
    protected SpawnerRecipeParams params;
    protected List<ICondition> recipeConditions;

    public SpawnerRecipeBuilder(ResourceLocation recipeId) {
        this.params = new SpawnerRecipeParams(recipeId);
        this.recipeConditions = new ArrayList<ICondition>();
    }

    public SpawnerRecipeBuilder withFluid(FluidIngredient fluidIngredient) {
        this.params.fluidIngredient = fluidIngredient;
        return this;
    }

    public SpawnerRecipeBuilder withFluid(FluidStack fluidStack) {
        return this.withFluid(FluidIngredient.fromFluidStack((FluidStack)fluidStack));
    }

    public SpawnerRecipeBuilder withFluid(ForgeFlowingFluid.Flowing pFluid, int pAmount) {
        return this.withFluid(FluidIngredient.fromFluid((Fluid)pFluid, (int)pAmount));
    }

    public SpawnerRecipeBuilder withMob(SpawnerRecipeOutput mob) {
        this.params.mob = mob;
        return this;
    }

    public SpawnerRecipeBuilder withProcessingTime(int processingTime) {
        this.params.processingTime = processingTime;
        return this;
    }

    public SpawnerRecipeBuilder withCustomLoot(NonNullList<ProcessingOutput> customLoot) {
        this.params.customLoot = customLoot;
        return this;
    }

    public SpawnerRecipeBuilder withCustomLoot(ProcessingOutput output) {
        this.params.customLoot.add((Object)output);
        return this;
    }

    public SpawnerRecipeBuilder withCustomLoot(float chance, ResourceLocation registryName, int amount) {
        return this.withCustomLoot(new ProcessingOutput(Pair.of((Object)registryName, (Object)amount), chance));
    }

    public SpawnerRecipe save() {
        return new SpawnerRecipe(this.params);
    }

    public void save(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        pFinishedRecipeConsumer.accept(this.buildFinishedRecipe());
    }

    private FinishedRecipe buildFinishedRecipe() {
        return new FinishedSpawnerRecipe(this.save());
    }

    public static class SpawnerRecipeParams {
        protected ResourceLocation id;
        protected FluidIngredient fluidIngredient;
        protected SpawnerRecipeOutput mob;
        protected int processingTime;
        protected NonNullList<ProcessingOutput> customLoot;

        protected SpawnerRecipeParams(ResourceLocation id) {
            this.id = id;
            this.mob = null;
            this.fluidIngredient = FluidIngredient.EMPTY;
            this.processingTime = 200;
            this.customLoot = NonNullList.m_122779_();
        }
    }

    protected static class FinishedSpawnerRecipe
    implements FinishedRecipe {
        protected ResourceLocation id;
        protected SpawnerRecipe recipe;

        protected FinishedSpawnerRecipe(SpawnerRecipe pRecipe) {
            this.recipe = pRecipe;
            this.id = pRecipe.m_6423_();
        }

        public void m_7917_(JsonObject pJson) {
            SpawnerRecipe.Serializer.INSTANCE.toJson(pJson, this.recipe);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeTypes.SPAWNER_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

