/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.compat.kubejs;

import com.google.gson.JsonObject;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerRecipeOutput;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.StringComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public interface SpawnerRecipeSchema {
    public static final RecipeKey<InputFluid> INGREDIENT = FluidComponents.INPUT.key("fluid");
    public static final RecipeKey<String> MOB = new StringComponent("not a valid living entity!", s -> {
        if (s == "random") {
            return true;
        }
        return ResourceLocation.m_135830_((String)s);
    }).key("mob").optional((Object)SpawnerRecipeOutput.EMPTY.toString());
    public static final RecipeKey<Integer> PROCESSING_TIME = NumberComponent.INT.key("processingTime").optional((Object)500);
    public static final RecipeKey<OutputItem[]> CUSTOM_LOOT = ItemComponents.OUTPUT_ARRAY.key("customLoot").optional((Object)new OutputItem[0]);
    public static final RecipeSchema SCHEMA = new RecipeSchema(SpawnerRecipeJS.class, SpawnerRecipeJS::new, new RecipeKey[]{INGREDIENT, MOB, PROCESSING_TIME, CUSTOM_LOOT});

    public static class SpawnerRecipeJS
    extends RecipeJS {
        public OutputItem readOutputItem(Object from) {
            JsonObject j;
            if (from instanceof ProcessingOutput) {
                ProcessingOutput output = (ProcessingOutput)from;
                return OutputItem.of((ItemStack)output.getStack(), (double)output.getChance());
            }
            OutputItem outputItem = super.readOutputItem(from);
            if (from instanceof JsonObject && (j = (JsonObject)from).has("chance")) {
                return outputItem.withChance((double)j.get("chance").getAsFloat());
            }
            return outputItem;
        }
    }
}

