/*
 * Decompiled with CFR 0.152.
 */
package net.tschipcraft.dynamiclights.neoforge;

import eu.midnightdust.lib.config.MidnightConfig;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.tschipcraft.dynamiclights.neoforge.Config;
import net.tschipcraft.dynamiclights.neoforge.sendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="dynamiclights")
public class Init {
    public static final String MODID = "dynamiclights";
    private static Logger LOGGER;

    public Init(IEventBus modEventBus, ModContainer modContainer) {
        block5: {
            try {
                if (LOGGER != null) {
                    LOGGER.info("[Dynamic Lights] Registering server started event...");
                }
                Class.forName("net.neoforged.neoforge.event.server.ServerStartedEvent");
                NeoForge.EVENT_BUS.register(new Object(this){

                    @SubscribeEvent
                    public void onServerStarted(ServerStartedEvent event) {
                        if (ModList.get().isLoaded("midnightlib")) {
                            LOGGER.info("[Dynamic Lights] Sending global config to world ...");
                            sendConfig.sendConfig(event.getServer());
                        }
                    }
                });
                if (ModList.get().isLoaded("midnightlib")) {
                    LOGGER.info("[Dynamic Lights] MidnightLib detected!");
                    Config.init((String)MODID, Config.class);
                    modContainer.registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> MidnightConfig.getScreen((Screen)parent, (String)MODID));
                }
                if (LOGGER != null) {
                    LOGGER.info("[Dynamic Lights] Loaded Dynamic Lights by Tschipcraft successfully!");
                }
            }
            catch (ClassNotFoundException e) {
                if (LOGGER == null) break block5;
                LOGGER.info("[Dynamic Lights] ServerStartedEvent not found, not registering event handler and config.");
            }
        }
    }

    static {
        try {
            LOGGER = LoggerFactory.getLogger((String)MODID);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

