/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.data;

import java.util.HashSet;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import umpaz.nethersdelight.common.registry.NDBlocks;
import umpaz.nethersdelight.common.registry.NDItems;

public class NDLang
extends LanguageProvider {
    public NDLang(PackOutput output) {
        super(output, "nethersdelight", "en_us");
    }

    protected void addTranslations() {
        HashSet blocks = new HashSet(NDBlocks.BLOCKS.getEntries());
        HashSet<RegistryObject> items = new HashSet<RegistryObject>(NDItems.ITEMS.getEntries());
        blocks.remove(NDBlocks.PROPELPLANT_WALL_TORCH);
        blocks.forEach(b -> {
            String name = ((Block)b.get()).m_7705_().replaceFirst("block.nethersdelight.", "");
            name = NDLang.toTitleCase(this.correctBlockItemName(name), "_").replaceAll("Of", "of");
            this.add(((Block)b.get()).m_7705_(), name);
        });
        items.removeIf(i -> i.get() instanceof BlockItem);
        items.forEach(i -> {
            String name = ((Item)i.get()).m_5524_().replaceFirst("item.nethersdelight.", "");
            name = NDLang.toTitleCase(this.correctBlockItemName(name), "_").replaceAll("Of", "of");
            this.add(((Item)i.get()).m_5524_(), name);
        });
        this.add("nethersdelight.itemGroup.main", "Nether's Delight");
        this.add("nethersdelight.container.blackstone_furnace", "Blackstone Furnace");
        this.add("nethersdelight.container.nether_brick_smoker", "Nether Brick Smoker");
        this.add("nethersdelight.container.blackstone_blast_furnace", "Blackstone Blast Furnace");
        this.add("nethersdelight.jei.composition", "Composition");
        this.add("nethersdelight.jei.composition.light", "Sped up by adjacent flames (see below)");
        this.add("nethersdelight.jei.composition.fluid", "Sped up by adjacent lava");
        this.add("nethersdelight.jei.composition.accelerators", "Sped up by adjacent activators (see below)");
        this.add("nethersdelight.jei.composition.nether", "Will only compose in the nether");
        this.add("nethersdelight.block.feast.use_knife", "You need a Knife to cut this.");
    }

    public String m_6055_() {
        return "Lang Entries";
    }

    public static String toTitleCase(String givenString, String regex) {
        String[] stringArray = givenString.split(regex);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).append(regex);
        }
        return stringBuilder.toString().trim().replaceAll(regex, " ").substring(0, stringBuilder.length() - 1);
    }

    public String correctBlockItemName(String name) {
        if (!name.endsWith("_bricks") && name.contains("bricks")) {
            name = name.replaceFirst("bricks", "brick");
        }
        if ((name.contains("_fence") || name.contains("_button")) && name.contains("planks")) {
            name = name.replaceFirst("_planks", "");
        }
        return name;
    }
}

