/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.fluidvessel;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.ConnectedLang;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlockEntity;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidVesselBlock
extends Block
implements IWrenchable,
IBE<FluidVesselBlockEntity> {
    public static final BooleanProperty POSITIVE = BooleanProperty.m_61465_((String)"positive");
    public static final BooleanProperty NEGATIVE = BooleanProperty.m_61465_((String)"negative");
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    private final boolean creative;
    static final VoxelShape CAMPFIRE_SMOKE_CLIP = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final SoundType SILENCED_METAL = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_12062_, () -> SoundEvents.f_12068_, () -> SoundEvents.f_12065_, () -> SoundEvents.f_12064_, () -> SoundEvents.f_12063_);

    public static FluidVesselBlock regular(BlockBehaviour.Properties p_i48440_1_) {
        return new FluidVesselBlock(p_i48440_1_, false);
    }

    public static FluidVesselBlock creative(BlockBehaviour.Properties p_i48440_1_) {
        return new FluidVesselBlock(p_i48440_1_, true);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy((Level)pLevel, (BlockPos)pPos, (LivingEntity)pPlacer);
    }

    protected FluidVesselBlock(BlockBehaviour.Properties p_i48440_1_, boolean creative) {
        super(p_i48440_1_);
        this.creative = creative;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POSITIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POSITIVE, (Comparable)Boolean.valueOf(true))).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW)));
    }

    public static boolean isVessel(BlockState state) {
        return state.m_60734_() instanceof FluidVesselBlock;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, FluidVesselBlockEntity::updateConnectivity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{POSITIVE, NEGATIVE, AXIS, SHAPE});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState placedOn;
        Direction.Axis preferredAxis;
        if (!(pContext.m_43723_() != null && pContext.m_43723_().m_6144_() || (preferredAxis = (Direction.Axis)(placedOn = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(pContext.m_43719_().m_122424_()))).m_61145_(AXIS).orElse(null)) == null)) {
            return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)preferredAxis);
        }
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        FluidVesselBlockEntity vesselAt = (FluidVesselBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (vesselAt == null) {
            return 0;
        }
        FluidVesselBlockEntity controllerBE = vesselAt.getControllerBE();
        if (controllerBE == null || !controllerBE.hasWindow()) {
            return 0;
        }
        return vesselAt.getLuminosity();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), FluidVesselBlockEntity::toggleWindows);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pContext == CollisionContext.m_82749_()) {
            return CAMPFIRE_SMOKE_CLIP;
        }
        return pState.m_60808_(pLevel, pPos);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.DOWN && pNeighborState.m_60734_() != this) {
            this.withBlockEntityDo((BlockGetter)pLevel, pCurrentPos, FluidTankBlockEntity::updateBoilerTemperature);
        }
        return pState;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        FluidVesselBlockEntity controllerBE;
        Fluid fluid;
        ItemStack heldItem = player.m_21120_(hand);
        boolean onClient = world.f_46443_;
        if (heldItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_7500_() && !this.creative) {
            return InteractionResult.PASS;
        }
        FluidHelper.FluidExchange exchange = null;
        FluidVesselBlockEntity be = (FluidVesselBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (be == null) {
            return InteractionResult.FAIL;
        }
        LazyOptional vesselCapability = be.getCapability(ForgeCapabilities.FLUID_HANDLER);
        if (!vesselCapability.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandler fluidVessel = (IFluidHandler)vesselCapability.orElse(null);
        FluidStack prevFluidInTank = fluidVessel.getFluidInTank(0).copy();
        if (FluidHelper.tryEmptyItemIntoBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (GenericItemEmptying.canItemBeEmptied((Level)world, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)world, (ItemStack)heldItem)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        SoundEvent soundevent = null;
        BlockState fluidState = null;
        FluidStack fluidInVessel = vesselCapability.map(fh -> fh.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
            FluidStack fluidInItem;
            if (this.creative && !onClient && !(fluidInItem = (FluidStack)GenericItemEmptying.emptyItem((Level)world, (ItemStack)heldItem, (boolean)true).getFirst()).isEmpty() && fluidVessel instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
                CreativeFluidTankBlockEntity.CreativeSmartFluidTank creativeVessel = (CreativeFluidTankBlockEntity.CreativeSmartFluidTank)fluidVessel;
                creativeVessel.setContainedFluid(fluidInItem);
            }
            fluid = fluidInVessel.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            soundevent = FluidHelper.getEmptySound((FluidStack)fluidInVessel);
        }
        if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
            if (this.creative && !onClient && fluidVessel instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
                CreativeFluidTankBlockEntity.CreativeSmartFluidTank creativeVessel = (CreativeFluidTankBlockEntity.CreativeSmartFluidTank)fluidVessel;
                creativeVessel.setContainedFluid(FluidStack.EMPTY);
            }
            fluid = prevFluidInTank.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            soundevent = FluidHelper.getFillSound((FluidStack)prevFluidInTank);
        }
        if (soundevent != null && !onClient) {
            float pitch = Mth.m_14036_((float)(1.0f - 1.0f * (float)fluidInVessel.getAmount() / (float)(FluidVesselBlockEntity.getCapacityMultiplier() * 16)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            world.m_5594_(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (world.f_46441_.m_188501_() - 0.5f) / 4.0f);
        }
        if (!fluidInVessel.isFluidStackIdentical(prevFluidInTank) && be instanceof FluidVesselBlockEntity && (controllerBE = be.getControllerBE()) != null) {
            if (fluidState != null && onClient) {
                BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, fluidState);
                float level = (float)fluidInVessel.getAmount() / (float)fluidVessel.getTankCapacity(0);
                boolean reversed = fluidInVessel.getFluid().getFluidType().isLighterThanAir();
                if (reversed) {
                    level = 1.0f - level;
                }
                Vec3 vec = ray.m_82450_();
                vec = new Vec3(vec.f_82479_, (double)((float)controllerBE.m_58899_().m_123342_() + level * ((float)controllerBE.getHeight() - 0.5f) + 0.25f), vec.f_82481_);
                Vec3 motion = player.m_20182_().m_82546_(vec).m_82490_((double)0.05f);
                vec = vec.m_82549_(motion);
                world.m_7106_((ParticleOptions)blockParticleData, vec.f_82479_, vec.f_82480_, vec.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                return InteractionResult.SUCCESS;
            }
            controllerBE.sendDataImmediately();
            controllerBE.m_6596_();
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof FluidVesselBlockEntity)) {
                return;
            }
            FluidVesselBlockEntity vesselBE = (FluidVesselBlockEntity)be;
            world.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)vesselBE);
        }
    }

    public Class<FluidVesselBlockEntity> getBlockEntityClass() {
        return FluidVesselBlockEntity.class;
    }

    public BlockEntityType<? extends FluidVesselBlockEntity> getBlockEntityType() {
        return this.creative ? (BlockEntityType)CCBlockEntityTypes.CREATIVE_FLUID_VESSEL.get() : (BlockEntityType)CCBlockEntityTypes.FLUID_VESSEL.get();
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction.Axis mirrorAxis = mirror == Mirror.FRONT_BACK ? Direction.Axis.X : Direction.Axis.Z;
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (axis == mirrorAxis) {
            return (BlockState)((BlockState)state.m_61124_((Property)POSITIVE, (Comparable)((Boolean)state.m_61143_((Property)NEGATIVE)))).m_61124_((Property)NEGATIVE, (Comparable)((Boolean)state.m_61143_((Property)POSITIVE)));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (axis == Direction.Axis.X) {
            return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
        }
        if (axis == Direction.Axis.Z) {
            return (BlockState)((BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)POSITIVE, (Comparable)((Boolean)state.m_61143_((Property)NEGATIVE)))).m_61124_((Property)NEGATIVE, (Comparable)((Boolean)state.m_61143_((Property)POSITIVE)));
        }
        return state;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceVesselSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(FluidVesselBlockEntity::getControllerBE).map(be -> ComparatorUtil.fractionToRedstoneLevel((double)be.getFillState())).orElse(0);
    }

    public static void updateBoilerState(BlockState pState, Level pLevel, BlockPos vesselPos) {
        BlockState vesselState = pLevel.m_8055_(vesselPos);
        Block block = vesselState.m_60734_();
        if (!(block instanceof FluidVesselBlock)) {
            return;
        }
        FluidVesselBlock vessel = (FluidVesselBlock)block;
        FluidVesselBlockEntity vesselBE = (FluidVesselBlockEntity)vessel.getBlockEntity((BlockGetter)pLevel, vesselPos);
        if (vesselBE == null) {
            return;
        }
        FluidVesselBlockEntity controllerBE = vesselBE.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        controllerBE.updateBoilerState();
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        WINDOW,
        WINDOW_TOP,
        WINDOW_MIDDLE,
        WINDOW_BOTTOM,
        WINDOW_SINGLE,
        WINDOW_TOP_SINGLE,
        WINDOW_MIDDLE_SINGLE,
        WINDOW_BOTTOM_SINGLE;


        public String m_7912_() {
            return ConnectedLang.asId((String)this.name());
        }

        public Shape nonSingleVariant() {
            return switch (this) {
                case WINDOW_SINGLE -> WINDOW;
                case WINDOW_TOP_SINGLE -> WINDOW_TOP;
                case WINDOW_MIDDLE_SINGLE -> WINDOW_MIDDLE;
                case WINDOW_BOTTOM_SINGLE -> WINDOW_BOTTOM;
                default -> this;
            };
        }
    }

    public static enum WindowType implements StringRepresentable
    {
        SIDE_WIDE,
        SIDE_NARROW_ENDS,
        SIDE_NARROW_THIRDS,
        SIDE_HORIZONTAL;


        public String m_7912_() {
            return ConnectedLang.asId((String)this.name());
        }
    }
}

