/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model;

import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ScaledBlockAndTintGetter
implements BlockAndTintGetter {
    protected final String renderingProperty;
    protected final BlockAndTintGetter wrapped;
    protected final BlockPos origin;
    protected final Vec3i originInner;
    protected final Vec3i scale;
    protected final Predicate<BlockPos> filter;

    public ScaledBlockAndTintGetter(String renderingProperty, BlockAndTintGetter wrapped, BlockPos origin, Vec3i originInner, Vec3i scale, Predicate<BlockPos> filter) {
        this.renderingProperty = renderingProperty;
        this.wrapped = wrapped;
        this.origin = origin;
        this.originInner = originInner;
        this.scale = scale;
        this.filter = filter;
    }

    public String getRenderingProperty() {
        return this.renderingProperty;
    }

    public String getPropertyForRender(BlockState state, BlockPos pos) {
        BlockPos truePos = this.getTruePos(pos);
        Vec3i inner = this.getInner(pos);
        return ((IMultiStateCopycatBlock)state.m_60734_()).getPropertyFromRender(this.getRenderingProperty(), state, (BlockGetter)this, inner, truePos);
    }

    public BlockAndTintGetter getWrapped() {
        return this.wrapped;
    }

    public Vec3i getScale() {
        return this.scale;
    }

    public BlockPos getTruePos(BlockPos pos) {
        return new BlockPos(this.origin.m_123341_() + (int)Math.floor((double)(pos.m_123341_() + this.originInner.m_123341_() - this.origin.m_123341_()) / (double)this.scale.m_123341_()), this.origin.m_123342_() + (int)Math.floor((double)(pos.m_123342_() + this.originInner.m_123342_() - this.origin.m_123342_()) / (double)this.scale.m_123342_()), this.origin.m_123343_() + (int)Math.floor((double)(pos.m_123343_() + this.originInner.m_123343_() - this.origin.m_123343_()) / (double)this.scale.m_123343_()));
    }

    public BlockPos getScaledPos(BlockPos pos) {
        return new BlockPos((pos.m_123341_() - this.origin.m_123341_()) * this.scale.m_123341_() + this.origin.m_123341_(), (pos.m_123342_() - this.origin.m_123342_()) * this.scale.m_123342_() + this.origin.m_123342_(), (pos.m_123343_() - this.origin.m_123343_()) * this.scale.m_123343_() + this.origin.m_123343_());
    }

    public Vec3i getInner(BlockPos pos) {
        int x = (pos.m_123341_() - this.origin.m_123341_() + this.originInner.m_123341_()) % this.scale.m_123341_();
        int y = (pos.m_123342_() - this.origin.m_123342_() + this.originInner.m_123342_()) % this.scale.m_123342_();
        int z = (pos.m_123343_() - this.origin.m_123343_() + this.originInner.m_123343_()) % this.scale.m_123343_();
        if (x < 0) {
            x += this.scale.m_123341_();
        }
        if (y < 0) {
            y += this.scale.m_123342_();
        }
        if (z < 0) {
            z += this.scale.m_123343_();
        }
        return new Vec3i(x, y, z);
    }

    public BlockEntity m_7702_(@NotNull BlockPos pPos) {
        if (!this.filter.test(pPos)) {
            return null;
        }
        BlockPos truePos = this.getTruePos(pPos);
        return this.wrapped.m_7702_(truePos);
    }

    @NotNull
    public BlockState m_8055_(@NotNull BlockPos pPos) {
        if (!this.filter.test(pPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockPos truePos = this.getTruePos(pPos);
        return this.wrapped.m_8055_(truePos);
    }

    @NotNull
    public FluidState m_6425_(@NotNull BlockPos pPos) {
        if (!this.filter.test(pPos)) {
            return Fluids.f_76191_.m_76145_();
        }
        BlockPos truePos = this.getTruePos(pPos);
        return this.wrapped.m_6425_(truePos);
    }

    public int m_141928_() {
        return this.wrapped.m_141928_();
    }

    public int m_141937_() {
        return this.wrapped.m_141937_();
    }

    public float m_7717_(@NotNull Direction pDirection, boolean pShade) {
        return this.wrapped.m_7717_(pDirection, pShade);
    }

    @NotNull
    public LevelLightEngine m_5518_() {
        return this.wrapped.m_5518_();
    }

    public int m_6171_(@NotNull BlockPos pBlockPos, @NotNull ColorResolver pColorResolver) {
        return this.wrapped.m_6171_(pBlockPos, pColorResolver);
    }
}

