/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.datagen;

import com.copycatsplus.copycats.CopycatRegistrate;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.datagen.CCTagGen;
import com.copycatsplus.copycats.foundation.tooltip.CopycatCharacteristics;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.function.BiConsumer;

public class CCDatagen {
    private static final CopycatRegistrate REGISTRATE = Copycats.getRegistrate();

    protected static void addExtraRegistrateData() {
        CCTagGen.addGenerators();
        REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            CCDatagen.provideDefaultLang("interface", langConsumer);
            CCDatagen.provideDefaultLang("tooltips", langConsumer);
            CCDatagen.provideCharacteristicsLang(langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/copycats/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void provideCharacteristicsLang(BiConsumer<String, String> consumer) {
        for (CopycatCharacteristics characteristic : CopycatCharacteristics.all()) {
            consumer.accept(characteristic.getTitleKey(), characteristic.getTitle());
            consumer.accept(characteristic.getDescriptionKey(), characteristic.getDescription());
        }
    }
}

