/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.util;

import io.github.cotrin8672.cem.util.EnchantableBlockMapping;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.placement.PlacementOffset;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"placeAlternativeBlockInWorld", "Lnet/minecraft/world/InteractionResult;", "Lnet/createmod/catnip/placement/PlacementOffset;", "world", "Lnet/minecraft/world/level/Level;", "blockItem", "Lnet/minecraft/world/item/BlockItem;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "ray", "Lnet/minecraft/world/phys/BlockHitResult;", "createenchantablemachinery"})
public final class PlacementOffsetExtensionKt {
    @NotNull
    public static final InteractionResult placeAlternativeBlockInWorld(@NotNull PlacementOffset $this$placeAlternativeBlockInWorld, @NotNull Level world, @NotNull BlockItem blockItem, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult ray) {
        Intrinsics.checkNotNullParameter((Object)$this$placeAlternativeBlockInWorld, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)blockItem, (String)"blockItem");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)ray, (String)"ray");
        if (!$this$placeAlternativeBlockInWorld.isReplaceable(world)) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        UseOnContext context = new UseOnContext(player, hand, ray);
        BlockPos newPos = new BlockPos($this$placeAlternativeBlockInWorld.getPos());
        ItemStack stackBefore = player.m_21120_(hand).m_41777_();
        if (!world.m_7966_(player, newPos)) {
            return InteractionResult.PASS;
        }
        Function function = $this$placeAlternativeBlockInWorld.getTransform();
        Block block = blockItem.m_40614_();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        Block block2 = EnchantableBlockMapping.getAlternativeBlock(block);
        BlockState state = (BlockState)function.apply(block2 != null ? block2.m_5573_(new BlockPlaceContext(player, hand, player.m_21120_(hand), ray)) : null);
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            FluidState fluidState = world.m_6425_(newPos);
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)fluidState.m_76152_(), (Object)Fluids.f_76193_)));
        }
        if (CatnipServices.HOOKS.playerPlaceSingleBlock(player, world, newPos, state)) {
            return InteractionResult.FAIL;
        }
        BlockState newState = world.m_8055_(newPos);
        SoundType soundType = newState.getSoundType((LevelReader)world, newPos, (Entity)player);
        world.m_5594_(null, newPos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.f_56731_ + 1.0f) / 2.0f, soundType.f_56732_ * 0.8f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)blockItem));
        newState.m_60734_().m_6402_(world, newPos, newState, (LivingEntity)player, stackBefore);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, newPos, context.m_43722_());
        }
        if (!player.m_7500_()) {
            context.m_43722_().m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }
}

