/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.util;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.cotrin8672.cem.mixin.KineticBlockEntityMixin;
import io.github.cotrin8672.cem.mixin.SmartBlockEntityMixin;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u0007*\u00020\u00022\u0016\u0010\b\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\n0\t\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\f*\u00020\u000f\u001a\n\u0010\u0011\u001a\u00020\f*\u00020\u0012\u001aF\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\f0\u001e\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001f"}, d2={"nonNullLevel", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "getNonNullLevel", "(Lnet/minecraft/world/level/block/entity/BlockEntity;)Lnet/minecraft/world/level/Level;", "holderLookup", "Lnet/minecraft/core/HolderLookup;", "T", "registryKey", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "smartBlockEntityTick", "", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "kineticBlockEntityTick", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "validateKinetics", "basinOperatingBlockEntityTick", "Lcom/simibubi/create/content/kinetics/mixer/MechanicalMixerBlockEntity;", "destroyBlockAs", "world", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedTool", "Lnet/minecraft/world/item/ItemStack;", "effectChance", "", "droppedItemCallback", "Lkotlin/Function1;", "createenchantablemachinery"})
public final class BlockEntityExtensionKt {
    @NotNull
    public static final Level getNonNullLevel(@NotNull BlockEntity $this$nonNullLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$nonNullLevel, (String)"<this>");
        Level level = $this$nonNullLevel.m_58904_();
        if (level == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return level;
    }

    @NotNull
    public static final <T> HolderLookup<T> holderLookup(@NotNull BlockEntity $this$holderLookup, @NotNull ResourceKey<? extends Registry<? extends T>> registryKey) {
        Intrinsics.checkNotNullParameter((Object)$this$holderLookup, (String)"<this>");
        Intrinsics.checkNotNullParameter(registryKey, (String)"registryKey");
        Level level = $this$holderLookup.m_58904_();
        if (level == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        HolderLookup holderLookup = level.m_246945_(registryKey);
        Intrinsics.checkNotNullExpressionValue((Object)holderLookup, (String)"holderLookup(...)");
        return holderLookup;
    }

    public static final void smartBlockEntityTick(@NotNull SmartBlockEntity $this$smartBlockEntityTick) {
        Intrinsics.checkNotNullParameter((Object)$this$smartBlockEntityTick, (String)"<this>");
        if (!((SmartBlockEntityMixin)$this$smartBlockEntityTick).getInitialized() && $this$smartBlockEntityTick.m_58898_()) {
            $this$smartBlockEntityTick.initialize();
            ((SmartBlockEntityMixin)$this$smartBlockEntityTick).setInitialized(true);
        }
        int n = ((SmartBlockEntityMixin)$this$smartBlockEntityTick).getLazyTickCounter();
        ((SmartBlockEntityMixin)$this$smartBlockEntityTick).setLazyTickCounter(n + -1);
        if (n <= 0) {
            ((SmartBlockEntityMixin)$this$smartBlockEntityTick).setLazyTickCounter(((SmartBlockEntityMixin)$this$smartBlockEntityTick).getLazyTickRate());
            $this$smartBlockEntityTick.lazyTick();
        }
        $this$smartBlockEntityTick.forEachBehaviour(BlockEntityBehaviour::tick);
    }

    public static final void kineticBlockEntityTick(@NotNull KineticBlockEntity $this$kineticBlockEntityTick) {
        Intrinsics.checkNotNullParameter((Object)$this$kineticBlockEntityTick, (String)"<this>");
        if (!BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)$this$kineticBlockEntityTick)).f_46443_ && $this$kineticBlockEntityTick.needsSpeedUpdate()) {
            $this$kineticBlockEntityTick.attachKinetics();
        }
        BlockEntityExtensionKt.smartBlockEntityTick((SmartBlockEntity)$this$kineticBlockEntityTick);
        ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).getEffects().tick();
        $this$kineticBlockEntityTick.preventSpeedUpdate = 0;
        if (BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)$this$kineticBlockEntityTick)).f_46443_) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> BlockEntityExtensionKt.kineticBlockEntityTick$lambda$0($this$kineticBlockEntityTick));
            return;
        }
        int n = ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).getValidationCountdown();
        ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).setValidationCountdown(n + -1);
        if (n <= 0) {
            ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).setValidationCountdown(((Number)AllConfigs.server().kinetics.kineticValidationFrequency.get()).intValue());
            BlockEntityExtensionKt.validateKinetics($this$kineticBlockEntityTick);
        }
        if ($this$kineticBlockEntityTick.getFlickerScore() > 0) {
            ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).setFlickerTally($this$kineticBlockEntityTick.getFlickerScore() - 1);
        }
        if ($this$kineticBlockEntityTick.networkDirty) {
            if ($this$kineticBlockEntityTick.hasNetwork()) {
                $this$kineticBlockEntityTick.getOrCreateNetwork().updateNetwork();
            }
            $this$kineticBlockEntityTick.networkDirty = false;
        }
    }

    public static final void validateKinetics(@NotNull KineticBlockEntity $this$validateKinetics) {
        Intrinsics.checkNotNullParameter((Object)$this$validateKinetics, (String)"<this>");
        if ($this$validateKinetics.hasSource()) {
            KineticBlockEntity sourceBE;
            if (!$this$validateKinetics.hasNetwork()) {
                $this$validateKinetics.removeSource();
                return;
            }
            if ($this$validateKinetics.source == null) {
                return;
            }
            if (!BlockEntityExtensionKt.getNonNullLevel((BlockEntity)$this$validateKinetics).m_46749_($this$validateKinetics.source)) {
                return;
            }
            BlockEntity blockEntity = BlockEntityExtensionKt.getNonNullLevel((BlockEntity)$this$validateKinetics).m_7702_($this$validateKinetics.source);
            KineticBlockEntity kineticBlockEntity = sourceBE = blockEntity instanceof KineticBlockEntity ? (KineticBlockEntity)blockEntity : null;
            if (sourceBE == null || sourceBE.getSpeed() == 0.0f) {
                $this$validateKinetics.removeSource();
                $this$validateKinetics.detachKinetics();
                return;
            }
            return;
        }
        if (!($this$validateKinetics.getSpeed() == 0.0f) && $this$validateKinetics.getGeneratedSpeed() == 0.0f) {
            $this$validateKinetics.setSpeed(0.0f);
        }
    }

    public static final void basinOperatingBlockEntityTick(@NotNull MechanicalMixerBlockEntity $this$basinOperatingBlockEntityTick) {
        Intrinsics.checkNotNullParameter((Object)$this$basinOperatingBlockEntityTick, (String)"<this>");
        if ($this$basinOperatingBlockEntityTick.basinRemoved) {
            $this$basinOperatingBlockEntityTick.basinRemoved = false;
            if (!$this$basinOperatingBlockEntityTick.running) {
                return;
            }
            $this$basinOperatingBlockEntityTick.runningTicks = 40;
            $this$basinOperatingBlockEntityTick.running = false;
            $this$basinOperatingBlockEntityTick.sendData();
            return;
        }
        BlockEntityExtensionKt.kineticBlockEntityTick((KineticBlockEntity)$this$basinOperatingBlockEntityTick);
    }

    public static final void destroyBlockAs(@NotNull Level world, @NotNull BlockPos pos, @Nullable Player player, @Nullable ItemStack usedTool, float effectChance, @NotNull Function1<? super ItemStack, Unit> droppedItemCallback) {
        BlockEntity blockEntity;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(droppedItemCallback, (String)"droppedItemCallback");
        FluidState fluidState = world.m_6425_(pos);
        BlockState state = world.m_8055_(pos);
        if (world.f_46441_.m_188501_() < effectChance) {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        BlockEntity blockEntity2 = blockEntity = state.m_155947_() ? world.m_7702_(pos) : null;
        if (player != null) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            ItemStack itemStack = usedTool;
            if (itemStack != null) {
                itemStack.m_41686_(world, state, pos, player);
            }
            player.m_36246_(Stats.f_12949_.m_12902_((Object)state.m_60734_()));
        }
        if (world instanceof ServerLevel && world.m_46469_().m_46207_(GameRules.f_46136_) && !world.restoringBlockSnapshots && (player == null || !player.m_7500_())) {
            ServerLevel serverLevel = (ServerLevel)world;
            Entity entity = (Entity)player;
            ItemStack itemStack = usedTool;
            if (itemStack == null) {
                itemStack = ItemStack.f_41583_;
            }
            for (ItemStack itemStack2 : Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)entity, (ItemStack)itemStack)) {
                Intrinsics.checkNotNull((Object)itemStack2);
                droppedItemCallback.invoke((Object)itemStack2);
            }
            if (state.m_60734_() instanceof IceBlock) {
                BlockState below;
                ItemStack itemStack3 = usedTool;
                boolean bl = itemStack3 != null ? itemStack3.getEnchantmentLevel(Enchantments.f_44985_) == 0 : false;
                if (bl && !((ServerLevel)world).m_6042_().f_63857_() && ((below = ((ServerLevel)world).m_8055_(pos.m_7495_())).m_280555_() || below.m_278721_())) {
                    fluidState = IceBlock.m_278844_().m_60819_();
                }
            }
            state.m_222967_((ServerLevel)world, pos, ItemStack.f_41583_, false);
        }
        world.m_46597_(pos, fluidState.m_76188_());
    }

    private static final Runnable kineticBlockEntityTick$lambda$0(KineticBlockEntity $this_kineticBlockEntityTick) {
        Intrinsics.checkNotNullParameter((Object)$this_kineticBlockEntityTick, (String)"$this_kineticBlockEntityTick");
        return () -> ((KineticBlockEntity)$this_kineticBlockEntityTick).tickAudio();
    }
}

