/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.saw;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntity;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntityDelegate;
import io.github.cotrin8672.cem.mixin.SawBlockEntityMixin;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import io.github.cotrin8672.cem.util.EnchantedItemFactory;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0016J\b\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030)0(H\u0002J\u001e\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u00020+H\u0016J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020+H\u0014J\u0018\u00104\u001a\u00020\"2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020+H\u0016J\u0011\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u000207H\u0096\u0001J\u000b\u00108\u001a\u0004\u0018\u000109H\u0096\u0001J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0(H\u0096\u0001J\u0011\u0010<\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0096\u0001J\u0011\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u000209H\u0096\u0001J\u0011\u0010?\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0096\u0001R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006@"}, d2={"Lio/github/cotrin8672/cem/content/block/saw/EnchantableSawBlockEntity;", "Lcom/simibubi/create/content/kinetics/saw/SawBlockEntity;", "Lio/github/cotrin8672/cem/content/block/EnchantableBlockEntity;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "getCapability", "Lnet/minecraftforge/common/util/LazyOptional;", "T", "", "cap", "Lnet/minecraftforge/common/capabilities/Capability;", "filtering", "Lcom/simibubi/create/foundation/blockEntity/behaviour/filtering/FilteringBehaviour;", "getFiltering", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/filtering/FilteringBehaviour;", "value", "", "recipeIndex", "getRecipeIndex", "()I", "setRecipeIndex", "(I)V", "cuttingRecipesKey", "getCuttingRecipesKey", "()Ljava/lang/Object;", "getBreakSpeed", "", "onBlockBroken", "", "stateToBreak", "start", "inserted", "Lnet/minecraft/world/item/ItemStack;", "getRecipes", "", "Lnet/minecraft/world/item/crafting/Recipe;", "addToGoggleTooltip", "", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "isPlayerSneaking", "read", "compound", "Lnet/minecraft/nbt/CompoundTag;", "clientPacket", "write", "getEnchantmentLevel", "enchantment", "Lnet/minecraft/world/item/enchantment/Enchantment;", "getEnchantmentTag", "Lnet/minecraft/nbt/ListTag;", "getEnchantments", "Lnet/minecraft/world/item/enchantment/EnchantmentInstance;", "readEnchantments", "setEnchantment", "listTag", "writeEnchantments", "createenchantablemachinery"})
public final class EnchantableSawBlockEntity
extends SawBlockEntity
implements EnchantableBlockEntity {
    private final /* synthetic */ EnchantableBlockEntityDelegate $$delegate_0;

    public EnchantableSawBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.$$delegate_0 = new EnchantableBlockEntityDelegate();
    }

    @Override
    @NotNull
    public List<EnchantmentInstance> getEnchantments() {
        return this.$$delegate_0.getEnchantments();
    }

    @Override
    @Nullable
    public ListTag getEnchantmentTag() {
        return this.$$delegate_0.getEnchantmentTag();
    }

    @Override
    public void setEnchantment(@NotNull ListTag listTag) {
        Intrinsics.checkNotNullParameter((Object)listTag, (String)"listTag");
        this.$$delegate_0.setEnchantment(listTag);
    }

    @Override
    public int getEnchantmentLevel(@NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        return ((EnchantableBlockEntity)this.$$delegate_0).getEnchantmentLevel(enchantment);
    }

    @Override
    public void readEnchantments(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.$$delegate_0.readEnchantments(compound);
    }

    @Override
    public void writeEnchantments(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.$$delegate_0.writeEnchantments(compound);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        Intrinsics.checkNotNullParameter(cap, (String)"cap");
        LazyOptional lazyOptional = super.getCapability(cap);
        Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"getCapability(...)");
        return lazyOptional;
    }

    private final FilteringBehaviour getFiltering() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
        FilteringBehaviour filteringBehaviour = ((SawBlockEntityMixin)((Object)this)).getFiltering();
        Intrinsics.checkNotNullExpressionValue((Object)filteringBehaviour, (String)"getFiltering(...)");
        return filteringBehaviour;
    }

    private final int getRecipeIndex() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
        return ((SawBlockEntityMixin)((Object)this)).getRecipeIndex();
    }

    private final void setRecipeIndex(int value) {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
        ((SawBlockEntityMixin)((Object)this)).setRecipeIndex(value);
    }

    private final Object getCuttingRecipesKey() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
        Object object = ((SawBlockEntityMixin)((Object)this)).getCuttingRecipesKey();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCuttingRecipesKey(...)");
        return object;
    }

    protected float getBreakSpeed() {
        Enchantment enchantment = Enchantments.f_44984_;
        Intrinsics.checkNotNullExpressionValue((Object)enchantment, (String)"BLOCK_EFFICIENCY");
        int efficiencyLevel = this.getEnchantmentLevel(enchantment);
        return super.getBreakSpeed() * (float)(efficiencyLevel + 1);
    }

    public void onBlockBroken(@NotNull BlockState stateToBreak) {
        Intrinsics.checkNotNullParameter((Object)stateToBreak, (String)"stateToBreak");
        Optional optional = TreeCutter.findDynamicTree((Block)stateToBreak.m_60734_(), (BlockPos)this.breakingPos);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findDynamicTree(...)");
        Optional dynamicTree = optional;
        ItemStack enchantedItem = EnchantedItemFactory.INSTANCE.getPickaxeItemStack(this.getEnchantmentTag());
        if (dynamicTree.isPresent()) {
            ((AbstractBlockBreakQueue)dynamicTree.get()).destroyBlocks(BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), enchantedItem, null, (arg_0, arg_1) -> ((EnchantableSawBlockEntity)this).dropItemFromCutTree(arg_0, arg_1));
            return;
        }
        Vec3 vec = VecHelper.offsetRandomly((Vec3)VecHelper.getCenterOf((Vec3i)((Vec3i)this.breakingPos)), (RandomSource)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this)).f_46441_, (float)0.125f);
        BlockHelper.destroyBlock((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (BlockPos)this.breakingPos, (float)1.0f, arg_0 -> EnchantableSawBlockEntity.onBlockBroken$lambda$0(this, vec, arg_0));
        TreeCutter.findTree((BlockGetter)((BlockGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this)), (BlockPos)this.breakingPos, (BlockState)stateToBreak).destroyBlocks(BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), enchantedItem, null, (arg_0, arg_1) -> ((EnchantableSawBlockEntity)this).dropItemFromCutTree(arg_0, arg_1));
    }

    public void start(@NotNull ItemStack inserted) {
        Recipe<?> recipe;
        Intrinsics.checkNotNullParameter((Object)inserted, (String)"inserted");
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.isEmpty()) {
            return;
        }
        if (BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this)).f_46443_ && !this.isVirtual()) {
            return;
        }
        List<Recipe<?>> recipes = this.getRecipes();
        boolean valid = !((Collection)recipes).isEmpty();
        Enchantment enchantment = Enchantments.f_44984_;
        Intrinsics.checkNotNullExpressionValue((Object)enchantment, (String)"BLOCK_EFFICIENCY");
        int efficiencyLevel = this.getEnchantmentLevel(enchantment);
        float efficiencyLevelModifier = Math.max(0.1f, 1.0f - (float)efficiencyLevel * 0.1f);
        float time = (float)50 * efficiencyLevelModifier;
        if (recipes.isEmpty()) {
            this.inventory.remainingTime = this.inventory.recipeDuration = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            int n = this.getRecipeIndex();
            this.setRecipeIndex(n + 1);
            if (this.getRecipeIndex() >= recipes.size()) {
                this.setRecipeIndex(0);
            }
        }
        if ((recipe = recipes.get(this.getRecipeIndex())) instanceof CuttingRecipe) {
            time = (float)((CuttingRecipe)recipe).getProcessingDuration() * efficiencyLevelModifier;
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = time * Math.max(1.0f, (float)inserted.m_41613_() / 5.0f);
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    private final List<Recipe<?>> getRecipes() {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inventory.getStackInSlot(0), (RecipeType)AllRecipeTypes.CUTTING.getType(), CuttingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
            FilteringBehaviour filteringBehaviour = ((SawBlockEntityMixin)((Object)this)).getFiltering();
            CuttingRecipe cuttingRecipe = (CuttingRecipe)assemblyRecipe.get();
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (filteringBehaviour.test(cuttingRecipe.m_8043_(level.m_9598_()))) {
                ImmutableList immutableList = ImmutableList.of(assemblyRecipe.get());
                Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
                return (List)immutableList;
            }
        }
        RecipeType[] recipeTypeArray = new RecipeType[]{AllRecipeTypes.CUTTING.getType(), (Boolean)AllConfigs.server().recipes.allowStonecuttingOnSaw.get() != false ? RecipeType.f_44112_ : null};
        Predicate types = RecipeConditions.isOfType((RecipeType[])recipeTypeArray);
        List startedSearch = RecipeFinder.get((Object)this.getCuttingRecipesKey(), (Level)this.f_58857_, (Predicate)types);
        Stream stream = startedSearch.stream();
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
        List<Recipe<?>> list = stream.filter(RecipeConditions.outputMatchesFilter((FilteringBehaviour)((SawBlockEntityMixin)((Object)this)).getFiltering())).filter(RecipeConditions.firstIngredientMatches((ItemStack)this.inventory.getStackInSlot(0))).filter(arg_0 -> EnchantableSawBlockEntity.getRecipes$lambda$2(EnchantableSawBlockEntity::getRecipes$lambda$1, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        for (EnchantmentInstance instance : this.getEnchantments()) {
            int level = instance.f_44948_;
            CreateLang.text((String)Strings.repeat((char)' ', (int)0)).add(instance.f_44947_.m_44700_(level).m_6881_()).forGoggles(tooltip);
        }
        return true;
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.readEnchantments(compound);
        super.read(compound, clientPacket);
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128473_("Enchantments");
        this.writeEnchantments(compound);
        super.write(compound, clientPacket);
    }

    private static final void onBlockBroken$lambda$0(EnchantableSawBlockEntity this$0, Vec3 $vec, ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.m_41619_()) {
            return;
        }
        if (!BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this$0).m_46469_().m_46207_(GameRules.f_46136_)) {
            return;
        }
        if (BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this$0)).restoringBlockSnapshots) {
            return;
        }
        ItemEntity itementity = new ItemEntity(BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this$0), $vec.f_82479_, $vec.f_82480_, $vec.f_82481_, stack);
        itementity.m_32060_();
        itementity.m_20256_(Vec3.f_82478_);
        BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this$0).m_7967_((Entity)itementity);
    }

    private static final boolean getRecipes$lambda$1(Recipe r) {
        return !AllRecipeTypes.shouldIgnoreInAutomation((Recipe)r);
    }

    private static final boolean getRecipes$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

