/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.roller;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.actors.roller.RollerMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import io.github.cotrin8672.cem.content.block.roller.EnchantableRollerActorVisual;
import io.github.cotrin8672.cem.content.block.roller.EnchantableRollerRenderer;
import io.github.cotrin8672.cem.util.EnchantedItemFactory;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0006H\u0014J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/cotrin8672/cem/content/block/roller/EnchantableRollerMovementBehaviour;", "Lcom/simibubi/create/content/contraptions/actors/roller/RollerMovementBehaviour;", "<init>", "()V", "enchantedTools", "", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "Lnet/minecraft/world/item/ItemStack;", "createVisual", "Lcom/simibubi/create/content/contraptions/render/ActorVisual;", "visualizationContext", "Ldev/engine_room/flywheel/api/visualization/VisualizationContext;", "simulationWorld", "Lcom/simibubi/create/foundation/virtualWorld/VirtualRenderWorld;", "movementContext", "destroyBlock", "", "context", "breakingPos", "Lnet/minecraft/core/BlockPos;", "getBlockBreakingSpeed", "", "canBeDisabledVia", "renderInContraption", "renderWorld", "matrices", "Lcom/simibubi/create/content/contraptions/render/ContraptionMatrices;", "buffers", "Lnet/minecraft/client/renderer/MultiBufferSource;", "createenchantablemachinery"})
public final class EnchantableRollerMovementBehaviour
extends RollerMovementBehaviour {
    @NotNull
    private Map<MovementContext, ItemStack> enchantedTools = new WeakHashMap();

    @NotNull
    public ActorVisual createVisual(@NotNull VisualizationContext visualizationContext, @NotNull VirtualRenderWorld simulationWorld, @NotNull MovementContext movementContext) {
        Intrinsics.checkNotNullParameter((Object)visualizationContext, (String)"visualizationContext");
        Intrinsics.checkNotNullParameter((Object)simulationWorld, (String)"simulationWorld");
        Intrinsics.checkNotNullParameter((Object)movementContext, (String)"movementContext");
        return (ActorVisual)new EnchantableRollerActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    protected void destroyBlock(@Nullable MovementContext context, @NotNull BlockPos breakingPos) {
        boolean noHarvest;
        Intrinsics.checkNotNullParameter((Object)breakingPos, (String)"breakingPos");
        if (context == null) {
            return;
        }
        BlockState blockState = context.world.m_8055_(breakingPos);
        boolean bl = noHarvest = blockState.m_204336_(BlockTags.f_144285_) || blockState.m_204336_(BlockTags.f_144286_) || blockState.m_204336_(BlockTags.f_144284_);
        if (this.enchantedTools.get(context) == null) {
            this.enchantedTools.put(context, EnchantedItemFactory.INSTANCE.getPickaxeItemStack(context));
        }
        BlockHelper.destroyBlockAs((Level)context.world, (BlockPos)breakingPos, null, (ItemStack)this.enchantedTools.get(context), (float)1.0f, arg_0 -> EnchantableRollerMovementBehaviour.destroyBlock$lambda$0(noHarvest, context, this, arg_0));
        super.destroyBlock(context, breakingPos);
    }

    protected float getBlockBreakingSpeed(@NotNull MovementContext context) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ItemStack enchantedTool = this.enchantedTools.get(context);
        if (enchantedTool == null) {
            ListTag enchantmentTag = context.blockEntityData.m_128437_("Enchantments", 10);
            n = (Integer)EnchantmentHelper.m_44882_((ListTag)enchantmentTag).get(Enchantments.f_44984_);
        } else {
            n = enchantedTool.getEnchantmentLevel(Enchantments.f_44984_);
        }
        Integer efficiencyLevel = n;
        Integer n2 = efficiencyLevel;
        return super.getBlockBreakingSpeed(context) * (float)((n2 != null ? n2 : 0) + 1);
    }

    @Nullable
    public ItemStack canBeDisabledVia(@Nullable MovementContext context) {
        return AllBlocks.MECHANICAL_ROLLER.asStack();
    }

    public void renderInContraption(@NotNull MovementContext context, @NotNull VirtualRenderWorld renderWorld, @NotNull ContraptionMatrices matrices, @NotNull MultiBufferSource buffers) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderWorld, (String)"renderWorld");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffers, (String)"buffers");
        if (!VisualizationManager.supportsVisualization((LevelAccessor)((LevelAccessor)context.world))) {
            EnchantableRollerRenderer.Companion.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    private static final void destroyBlock$lambda$0(boolean $noHarvest, MovementContext $context, EnchantableRollerMovementBehaviour this$0, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if ($noHarvest || $context.world.f_46441_.m_188499_()) {
            return;
        }
        this$0.dropItem($context, it);
    }
}

