/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.mixer;

import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntity;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntityDelegate;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import java.util.List;
import joptsimple.internal.Strings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0014J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096\u0001J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0001J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0096\u0001J\u0011\u0010!\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0011\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u001dH\u0096\u0001J\u0011\u0010$\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001\u00a8\u0006%"}, d2={"Lio/github/cotrin8672/cem/content/block/mixer/EnchantableMechanicalMixerBlockEntity;", "Lcom/simibubi/create/content/kinetics/mixer/MechanicalMixerBlockEntity;", "Lio/github/cotrin8672/cem/content/block/EnchantableBlockEntity;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tick", "", "addToGoggleTooltip", "", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "isPlayerSneaking", "read", "compound", "Lnet/minecraft/nbt/CompoundTag;", "clientPacket", "write", "getEnchantmentLevel", "", "enchantment", "Lnet/minecraft/world/item/enchantment/Enchantment;", "getEnchantmentTag", "Lnet/minecraft/nbt/ListTag;", "getEnchantments", "", "Lnet/minecraft/world/item/enchantment/EnchantmentInstance;", "readEnchantments", "setEnchantment", "listTag", "writeEnchantments", "createenchantablemachinery"})
public final class EnchantableMechanicalMixerBlockEntity
extends MechanicalMixerBlockEntity
implements EnchantableBlockEntity {
    private final /* synthetic */ EnchantableBlockEntityDelegate $$delegate_0;

    public EnchantableMechanicalMixerBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.$$delegate_0 = new EnchantableBlockEntityDelegate();
    }

    @Override
    @NotNull
    public List<EnchantmentInstance> getEnchantments() {
        return this.$$delegate_0.getEnchantments();
    }

    @Override
    @Nullable
    public ListTag getEnchantmentTag() {
        return this.$$delegate_0.getEnchantmentTag();
    }

    @Override
    public void setEnchantment(@NotNull ListTag listTag) {
        Intrinsics.checkNotNullParameter((Object)listTag, (String)"listTag");
        this.$$delegate_0.setEnchantment(listTag);
    }

    @Override
    public int getEnchantmentLevel(@NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        return ((EnchantableBlockEntity)this.$$delegate_0).getEnchantmentLevel(enchantment);
    }

    @Override
    public void readEnchantments(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.$$delegate_0.readEnchantments(compound);
    }

    @Override
    public void writeEnchantments(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.$$delegate_0.writeEnchantments(compound);
    }

    public void tick() {
        BlockEntityExtensionKt.basinOperatingBlockEntityTick(this);
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            this.basinChecker.scheduleUpdate();
            return;
        }
        float speed = Math.abs(this.speed);
        if (this.running && this.f_58857_ != null) {
            if (BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this)).f_46443_ && this.runningTicks == 20) {
                this.renderParticles();
            }
            if ((!BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this)).f_46443_ || this.isVirtual()) && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    Couple tanks;
                    float recipeSpeed = 1.0f;
                    if (this.currentRecipe instanceof ProcessingRecipe) {
                        Recipe recipe = this.currentRecipe;
                        Intrinsics.checkNotNull((Object)recipe, (String)"null cannot be cast to non-null type com.simibubi.create.content.processing.recipe.ProcessingRecipe<*>");
                        int t = ((ProcessingRecipe)recipe).getProcessingDuration();
                        if (t != 0) {
                            recipeSpeed = (float)t / 100.0f;
                        }
                    }
                    double d = 1.0;
                    Enchantment enchantment = Enchantments.f_44984_;
                    Intrinsics.checkNotNullExpressionValue((Object)enchantment, (String)"BLOCK_EFFICIENCY");
                    double efficiencyModifier = d + 0.2 * (double)this.getEnchantmentLevel(enchantment);
                    this.processingTicks = Mth.m_14045_((int)((int)((double)(MathKt.log2((float)((float)512 / speed)) * (float)Math.ceil(recipeSpeed * (float)15)) / efficiencyModifier)), (int)1, (int)512);
                    if (!(!this.getBasin().isPresent() || ((SmartFluidTankBehaviour)(tanks = ((BasinBlockEntity)this.getBasin().get()).getTanks()).getFirst()).isEmpty() && ((SmartFluidTankBehaviour)tanks.getSecond()).isEmpty())) {
                        BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this).m_5594_(null, this.f_58858_, SoundEvents.f_11776_, SoundSource.BLOCKS, 0.75f, speed < 65.0f ? 0.75f : 1.5f);
                    }
                } else {
                    int n = this.processingTicks;
                    this.processingTicks = n + -1;
                    if (this.processingTicks == 0) {
                        n = this.runningTicks;
                        this.runningTicks = n + 1;
                        this.processingTicks = -1;
                        this.applyBasinRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                int n = this.runningTicks;
                this.runningTicks = n + 1;
            }
        }
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        for (EnchantmentInstance instance : this.getEnchantments()) {
            int level = instance.f_44948_;
            CreateLang.text((String)Strings.repeat((char)' ', (int)0)).add(instance.f_44947_.m_44700_(level).m_6881_()).forGoggles(tooltip);
        }
        return true;
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.readEnchantments(compound);
        super.read(compound, clientPacket);
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128473_("Enchantments");
        this.writeEnchantments(compound);
        super.write(compound, clientPacket);
    }
}

