/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SingleKeyMultimap<K, V>
implements Multimap<K, V> {
    @Nonnull
    private final K key;
    @Nonnull
    private final Collection<V> values;
    private transient Collection<V> unmodifiableValues;
    private transient Set<K> keySet;
    private transient Multiset<K> keyMultiset;
    private transient Map<K, Collection<V>> asMap;
    private transient Collection<Map.Entry<K, V>> entries;

    private void validateKey(@Nullable Object key) {
        if (key != this.key) {
            throw new IllegalArgumentException("Cannot modify a single key multimap with mismatching key");
        }
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean containsKey(@Nullable Object key) {
        return key == this.key;
    }

    public boolean containsValue(@Nullable Object value) {
        return this.values.contains(value);
    }

    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        return key == this.key && this.values.contains(value);
    }

    public boolean put(@Nullable K key, @Nullable V value) {
        this.validateKey(key);
        return this.values.add(value);
    }

    public boolean remove(@Nullable Object key, @Nullable Object value) {
        this.validateKey(key);
        return this.values.remove(value);
    }

    public boolean putAll(@Nullable K key, Iterable<? extends V> values) {
        this.validateKey(key);
        boolean didChange = false;
        for (V value : values) {
            didChange |= this.values.add(value);
        }
        return didChange;
    }

    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean didChange = false;
        for (Map.Entry entry : multimap.entries()) {
            didChange |= this.put(entry.getKey(), entry.getValue());
        }
        return didChange;
    }

    public Collection<V> removeAll(@Nullable Object key) {
        List<V> values = List.copyOf(this.values);
        this.values.clear();
        return values;
    }

    public Collection<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        this.validateKey(key);
        Collection<V> returnValues = this.removeAll(key);
        this.putAll(key, values);
        return returnValues;
    }

    public void clear() {
        this.values.clear();
    }

    public Collection<V> get(@Nullable K key) {
        if (key == this.key) {
            return this.values;
        }
        return Collections.emptyList();
    }

    public Collection<V> values() {
        if (this.unmodifiableValues == null) {
            this.unmodifiableValues = Collections.unmodifiableCollection(this.values);
        }
        return this.unmodifiableValues;
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.singleton(this.key);
        }
        return this.keySet;
    }

    public Multiset<K> keys() {
        if (this.keyMultiset == null) {
            this.keyMultiset = ImmutableMultiset.of(this.key);
        }
        return this.keyMultiset;
    }

    public Map<K, Collection<V>> asMap() {
        if (this.asMap == null) {
            this.asMap = Map.of(this.key, this.values);
        }
        return this.asMap;
    }

    public Collection<Map.Entry<K, V>> entries() {
        if (this.entries == null) {
            this.entries = new SingleKeyEntries();
        }
        return this.entries;
    }

    public SingleKeyMultimap(@Nonnull K key, @Nonnull Collection<V> values) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.key = key;
        this.values = values;
    }

    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Nonnull
    public Collection<V> getValues() {
        return this.values;
    }

    private class SingleKeyEntries
    extends AbstractCollection<Map.Entry<K, V>> {
        private SingleKeyEntries() {
        }

        private SingleKeyMultimap<K, V> getMap() {
            return SingleKeyMultimap.this;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new SingleKeyIterator();
        }

        @Override
        public boolean contains(@Nullable Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return SingleKeyMultimap.this.containsEntry(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(@Nullable Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return SingleKeyMultimap.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public int size() {
            return SingleKeyMultimap.this.values.size();
        }

        @Override
        public void clear() {
            SingleKeyMultimap.this.clear();
        }

        @Override
        public int hashCode() {
            return 31 * SingleKeyMultimap.this.values.hashCode() + SingleKeyMultimap.this.key.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            SingleKeyMultimap otherMap = ((SingleKeyEntries)obj).getMap();
            return otherMap.key.equals(SingleKeyMultimap.this.key) && otherMap.values.equals(SingleKeyMultimap.this.values);
        }
    }

    private class SingleKeyIterator
    extends AbstractIterator<Map.Entry<K, V>> {
        private final Iterator<V> values;

        private SingleKeyIterator() {
            this.values = SingleKeyMultimap.this.values.iterator();
        }

        protected Map.Entry<K, V> computeNext() {
            if (!this.values.hasNext()) {
                return (Map.Entry)this.endOfData();
            }
            return new SingleKeyEntry(this.values.next());
        }
    }

    private class SingleKeyEntry
    implements Map.Entry<K, V> {
        private V value;

        @Override
        public K getKey() {
            return SingleKeyMultimap.this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.value;
            if (!SingleKeyMultimap.this.values.remove(this.value)) {
                throw new IllegalStateException("Entry already removed");
            }
            if (!SingleKeyMultimap.this.values.add(this.value)) {
                try {
                    if (!SingleKeyMultimap.this.values.add(oldValue)) {
                        throw new IllegalStateException("Failed to restore collection after failing to add new value");
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to restore collection after failing to add new value", ex);
                }
                throw new IllegalArgumentException("Failed to add entry");
            }
            this.value = value;
            return oldValue;
        }

        public SingleKeyEntry(V value) {
            this.value = value;
        }
    }
}

