/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public record LoadableIngredientSerializer<T extends Ingredient>(RecordLoadable<T> loadable) implements IIngredientSerializer<T>
{
    public T parse(FriendlyByteBuf buffer) {
        return (T)((Ingredient)this.loadable.decode(buffer));
    }

    public T parse(JsonObject json) {
        return (T)((Ingredient)this.loadable.deserialize(json));
    }

    public void write(FriendlyByteBuf buffer, T ingredient) {
        this.loadable.encode(buffer, ingredient);
    }

    public JsonObject serialize(T ingredient) {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.requireNonNull(CraftingHelper.getID((IIngredientSerializer)this)).toString());
        this.loadable.serialize(ingredient, json);
        return json;
    }
}

