/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.util.JsonHelper;

public abstract class TagCondition<T>
implements ICondition {
    protected final TagKey<T> tag;
    @Nullable
    private Optional<Registry<T>> registry;

    @Nullable
    protected Registry<T> registry(LootContext context) {
        if (this.registry == null) {
            this.registry = context.m_78952_().m_9598_().m_6632_(this.tag.f_203867_());
            if (this.registry.isEmpty()) {
                Mantle.logger.error("Failed to find registry for tag " + this.tag + " in " + this.getClass().getSimpleName() + ", this indicates a broken resource or datapack.");
            }
        }
        return this.registry.orElse(null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(\"" + this.tag + "\")";
    }

    public TagCondition(TagKey<T> tag) {
        this.tag = tag;
    }

    public TagKey<T> getTag() {
        return this.tag;
    }

    public record Serializer<C extends TagCondition<?>>(ResourceLocation getID, Function<TagKey<?>, C> constructor) implements IConditionSerializer<C>,
    net.minecraft.world.level.storage.loot.Serializer<C>
    {
        public void write(JsonObject json, C value) {
            TagKey tag = ((TagCondition)value).getTag();
            if (!Registries.f_256913_.equals((Object)tag.f_203867_())) {
                json.addProperty("registry", tag.f_203867_().m_135782_().toString());
            }
            json.addProperty("tag", tag.f_203868_().toString());
        }

        public C read(JsonObject json) {
            return (C)((TagCondition)this.constructor.apply(TagKey.m_203882_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)JsonHelper.getResourceLocation(json, "registry", Registries.f_256913_.m_135782_())), (ResourceLocation)JsonHelper.getResourceLocation(json, "tag"))));
        }

        public void serialize(JsonObject json, C value, JsonSerializationContext context) {
            this.write(json, value);
        }

        public C deserialize(JsonObject json, JsonDeserializationContext context) {
            return (C)this.read(json);
        }
    }
}

