/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.registry.AbstractNamedComponentRegistry;

public class NamedComponentRegistry<T>
extends AbstractNamedComponentRegistry<T> {
    private final BiMap<ResourceLocation, T> values = HashBiMap.create();

    public NamedComponentRegistry(String errorText) {
        super(errorText);
    }

    public synchronized <V extends T> V register(ResourceLocation name, V value) {
        if (this.values.putIfAbsent((Object)name, value) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return value;
    }

    @Override
    @Nullable
    public T getValue(ResourceLocation name) {
        return (T)this.values.get((Object)name);
    }

    @Nullable
    public ResourceLocation getOptionalKey(T value) {
        return (ResourceLocation)this.values.inverse().get(value);
    }

    @Override
    public ResourceLocation getKey(T value) {
        ResourceLocation key = this.getOptionalKey(value);
        if (key == null) {
            throw new IllegalStateException(this.errorText + value);
        }
        return key;
    }

    @Override
    public Collection<ResourceLocation> getKeys() {
        return this.values.keySet();
    }

    @Override
    public Collection<T> getValues() {
        return this.values.values();
    }
}

