/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.primitive;

import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.array.CharArrayLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public enum CharacterLoadable implements StringLoadable<Character>
{
    INSTANCE;

    public static final CharacterLoadable DEFAULT;

    @Override
    public Character parseString(String value, String key, TypedMap context) {
        if (value.length() == 1) {
            return Character.valueOf(value.charAt(0));
        }
        throw new JsonSyntaxException("Too many characters at '" + key + "'");
    }

    @Override
    public String getString(Character object) {
        return object.toString();
    }

    @Override
    public Character decode(FriendlyByteBuf buffer, TypedMap context) {
        return Character.valueOf(buffer.readChar());
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Character value) {
        buffer.writeChar((int)value.charValue());
    }

    public ArrayLoadable<char[]> array(int minSize, int maxSize) {
        return new CharArrayLoadable(this, minSize, maxSize);
    }

    public ArrayLoadable<char[]> array(int minSize) {
        return this.array(minSize, Integer.MAX_VALUE);
    }

    static {
        DEFAULT = INSTANCE;
    }
}

