/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable;

import java.util.function.BiFunction;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.loot.LootModifierManager;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.common.GsonLoadable;
import slimeknights.mantle.data.loadable.common.RegistryLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.primitive.ResourceLocationLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;

public class Loadables {
    public static final StringLoadable<ResourceLocation> RESOURCE_LOCATION = StringLoadable.DEFAULT.xmap((s, e) -> {
        try {
            return new ResourceLocation(s);
        }
        catch (ResourceLocationException ex) {
            throw e.create((RuntimeException)((Object)ex));
        }
    }, (r, e) -> r.toString());
    public static final StringLoadable<ToolAction> TOOL_ACTION = StringLoadable.DEFAULT.flatXmap(ToolAction::get, ToolAction::name);
    public static final ResourceLocationLoadable<SoundEvent> SOUND_EVENT = new RegistryLoadable<SoundEvent>(BuiltInRegistries.f_256894_);
    public static final ResourceLocationLoadable<Fluid> FLUID = new RegistryLoadable<Fluid>((Registry<Fluid>)BuiltInRegistries.f_257020_);
    public static final ResourceLocationLoadable<MobEffect> MOB_EFFECT = new RegistryLoadable<MobEffect>(BuiltInRegistries.f_256974_);
    public static final ResourceLocationLoadable<Block> BLOCK = new RegistryLoadable<Block>((Registry<Block>)BuiltInRegistries.f_256975_);
    public static final ResourceLocationLoadable<Enchantment> ENCHANTMENT = new RegistryLoadable<Enchantment>(BuiltInRegistries.f_256876_);
    public static final ResourceLocationLoadable<EntityType<?>> ENTITY_TYPE = new RegistryLoadable((Registry<EntityType<?>>)BuiltInRegistries.f_256780_);
    public static final ResourceLocationLoadable<Item> ITEM = new RegistryLoadable<Item>((Registry<Item>)BuiltInRegistries.f_257033_);
    public static final ResourceLocationLoadable<Potion> POTION = new RegistryLoadable<Potion>((Registry<Potion>)BuiltInRegistries.f_256980_);
    public static final ResourceLocationLoadable<ParticleType<?>> PARTICLE_TYPE = new RegistryLoadable(BuiltInRegistries.f_257034_);
    public static final ResourceLocationLoadable<BlockEntityType<?>> BLOCK_ENTITY_TYPE = new RegistryLoadable(BuiltInRegistries.f_257049_);
    public static final ResourceLocationLoadable<Attribute> ATTRIBUTE = new RegistryLoadable<Attribute>(BuiltInRegistries.f_256951_);
    public static final StringLoadable<Fluid> NON_EMPTY_FLUID = Loadables.notValue(FLUID, Fluids.f_76191_, "Fluid cannot be empty");
    public static final StringLoadable<Block> NON_EMPTY_BLOCK = Loadables.notValue(BLOCK, Blocks.f_50016_, "Block cannot be air");
    public static final StringLoadable<Item> NON_EMPTY_ITEM = Loadables.notValue(ITEM, Items.f_41852_, "Item cannot be empty");
    public static final StringLoadable<TagKey<Fluid>> FLUID_TAG = Loadables.tagKey(Registries.f_256808_);
    public static final StringLoadable<TagKey<MobEffect>> MOB_EFFECT_TAG = Loadables.tagKey(Registries.f_256929_);
    public static final StringLoadable<TagKey<Block>> BLOCK_TAG = Loadables.tagKey(Registries.f_256747_);
    public static final StringLoadable<TagKey<Enchantment>> ENCHANTMENT_TAG = Loadables.tagKey(Registries.f_256762_);
    public static final StringLoadable<TagKey<EntityType<?>>> ENTITY_TYPE_TAG = Loadables.tagKey(Registries.f_256939_);
    public static final StringLoadable<TagKey<Item>> ITEM_TAG = Loadables.tagKey(Registries.f_256913_);
    public static final StringLoadable<TagKey<Potion>> POTION_TAG = Loadables.tagKey(Registries.f_256973_);
    public static final StringLoadable<TagKey<BlockEntityType<?>>> BLOCK_ENTITY_TYPE_TAG = Loadables.tagKey(Registries.f_256922_);
    public static final StringLoadable<TagKey<DamageType>> DAMAGE_TYPE_TAG = Loadables.tagKey(Registries.f_268580_);
    public static final StringLoadable<ResourceKey<DamageType>> DAMAGE_TYPE_KEY = Loadables.resourceKey(Registries.f_268580_);
    public static final Loadable<LootPoolEntryContainer> LOOT_ENTRY = new GsonLoadable<LootPoolEntryContainer>(LootModifierManager.GSON_INSTANCE, LootPoolEntryContainer.class);
    public static final Loadable<Integer> ROTATION = new IntLoadable(0, 270, IntLoadable.IntNetwork.SHORT).validate((value, error) -> {
        if (!ModelHelper.checkRotation(value.intValue())) {
            throw error.create("Rotation must be 0/90/180/270");
        }
        return value;
    });
    public static final EnumLoadable<Direction> DIRECTION = new EnumLoadable<Direction>(Direction.class);

    private Loadables() {
    }

    public static <T> StringLoadable<TagKey<T>> tagKey(ResourceKey<? extends Registry<T>> registry) {
        return RESOURCE_LOCATION.flatXmap(key -> TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)key), TagKey::f_203868_);
    }

    public static <T> StringLoadable<ResourceKey<T>> resourceKey(ResourceKey<? extends Registry<T>> registry) {
        return RESOURCE_LOCATION.flatXmap(key -> ResourceKey.m_135785_((ResourceKey)registry, (ResourceLocation)key), ResourceKey::m_135782_);
    }

    public static <T> StringLoadable<T> notValue(StringLoadable<T> loadable, T notValue, String errorMsg) {
        BiFunction<Object, ErrorFactory, Object> mapper = (value, error) -> {
            if (value == notValue) {
                throw error.create(errorMsg);
            }
            return value;
        };
        return loadable.xmap(mapper, mapper);
    }
}

