/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.mantle.util.TranslationHelper;

public class GaugeBlock
extends Block {
    private static final String CAPACITY_KEY = Mantle.makeDescriptionId("gui", "fluid.capacity");
    private static final String CONTENTS_KEY = Mantle.makeDescriptionId("gui", "fluid.contents");
    private static final String CONTENTS_FORMAT = Mantle.makeDescriptionId("gui", "fluid.format");
    private static final VoxelShape[] BOUNDS = new VoxelShape[]{GaugeBlock.m_49796_((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), GaugeBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), GaugeBlock.m_49796_((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0), GaugeBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0), GaugeBlock.m_49796_((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), GaugeBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0)};

    public GaugeBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH));
    }

    public static MutableComponent formatCapacity(int capacity) {
        return Component.m_237110_((String)CAPACITY_KEY, (Object[])new Object[]{TranslationHelper.COMMA_FORMAT.format(capacity)});
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IFluidHandler handler;
        Direction side;
        BlockEntity te;
        if (!world.m_5776_() && (te = world.m_7702_(pos.m_121945_((side = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_()))) != null && (handler = (IFluidHandler)te.getCapability(ForgeCapabilities.FLUID_HANDLER, side).orElse((Object)EmptyFluidHandler.INSTANCE)).getTanks() > 0) {
            FluidStack fluid = handler.getFluidInTank(0);
            if (fluid.isEmpty()) {
                player.m_5661_((Component)GaugeBlock.formatCapacity(handler.getTankCapacity(0)), true);
            } else {
                Component contents = fluid.getDisplayName();
                if (!RegistryHelper.contains(BuiltInRegistries.f_257049_, MantleTags.BlockEntities.HIDES_GAUGE_AMOUNT, te.m_58903_())) {
                    contents = Component.m_237110_((String)CONTENTS_FORMAT, (Object[])new Object[]{TranslationHelper.COMMA_FORMAT.format(fluid.getAmount()), TranslationHelper.COMMA_FORMAT.format(handler.getTankCapacity(0)), contents});
                }
                player.m_5661_((Component)Component.m_237110_((String)CONTENTS_KEY, (Object[])new Object[]{contents}), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BOUNDS[((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122411_()];
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockEntity te = world.m_7702_(pos.m_121945_(direction.m_122424_()));
        return te != null && te.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).isPresent();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] nearestDir;
        BlockState state = this.m_49966_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction direction : nearestDir = context.m_6232_()) {
            if (!(state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction.m_122424_())).m_60710_((LevelReader)world, pos)) continue;
            return state;
        }
        return null;
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122424_() == state.m_61143_((Property)BlockStateProperties.f_61372_) && !state.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
    }
}

