/*
 * Decompiled with CFR 0.152.
 */
package io.github.suel_ki.foodeffecttooltips;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.suel_ki.foodeffecttooltips.config.FoodEffectsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class TooltipHelper {
    public static boolean shouldShowTooltip(ItemStack stack) {
        Item item = stack.m_41720_();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        boolean isWhitelist = (Boolean)FoodEffectsConfig.UseAsWhitelistInstead.get();
        if (((List)FoodEffectsConfig.BlacklistedItemIdentifiers.get()).contains(id.toString())) {
            return isWhitelist;
        }
        if (((List)FoodEffectsConfig.BlacklistedModsIDs.get()).contains(id.m_135827_())) {
            return isWhitelist;
        }
        return !isWhitelist;
    }

    public static void addFoodComponentEffectTooltip(ItemStack stack, List<Component> tooltip) {
        FoodProperties foodProperties = stack.m_41720_().m_41473_();
        if (foodProperties != null) {
            boolean isDrink = stack.m_41780_() == UseAnim.DRINK;
            TooltipHelper.buildFoodEffectTooltip(tooltip, foodProperties.m_38749_(), isDrink);
        }
    }

    public static void buildFoodEffectTooltip(List<Component> tooltip, List<Pair<MobEffectInstance, Float>> effectsWithChance, boolean drink) {
        if (effectsWithChance.isEmpty()) {
            return;
        }
        ArrayList modifiersList = Lists.newArrayList();
        for (Pair<MobEffectInstance, Float> entry : effectsWithChance) {
            MobEffectInstance mobEffectInstance = (MobEffectInstance)entry.getFirst();
            Float chance = (Float)entry.getSecond();
            MutableComponent translatableComponent = Component.m_237115_((String)mobEffectInstance.m_19576_());
            MobEffect mobEffect = mobEffectInstance.m_19544_();
            Map map = mobEffect.m_19485_();
            if (!map.isEmpty()) {
                for (Map.Entry entityAttributeEntityAttributeModifierEntry : map.entrySet()) {
                    AttributeModifier entityAttributeModifier = (AttributeModifier)entityAttributeEntityAttributeModifierEntry.getValue();
                    AttributeModifier entityAttributeModifier2 = new AttributeModifier(entityAttributeModifier.m_22214_(), mobEffect.m_7048_(mobEffectInstance.m_19564_(), entityAttributeModifier), entityAttributeModifier.m_22217_());
                    modifiersList.add(new Pair((Object)((Attribute)entityAttributeEntityAttributeModifierEntry.getKey()), (Object)entityAttributeModifier2));
                }
            }
            if (mobEffectInstance.m_19564_() > 0) {
                translatableComponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{translatableComponent, Component.m_237115_((String)("potion.potency." + mobEffectInstance.m_19564_()))});
            }
            if (mobEffectInstance.m_19557_() > 20) {
                translatableComponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{translatableComponent, StringUtil.m_14404_((int)mobEffectInstance.m_19557_())});
            }
            if (chance.floatValue() < 1.0f) {
                translatableComponent = Component.m_237110_((String)"foodeffecttooltips.food.withChance", (Object[])new Object[]{translatableComponent, Math.round(chance.floatValue() * 100.0f)});
            }
            tooltip.add((Component)translatableComponent.m_130940_(mobEffect.m_19483_().m_19497_()));
        }
        if (!modifiersList.isEmpty()) {
            tooltip.add(CommonComponents.f_237098_);
            if (drink) {
                tooltip.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"foodeffecttooltips.food.whenEaten").m_130940_(ChatFormatting.DARK_PURPLE));
            }
            for (Pair entityAttributeEntityAttributeModifierPair : modifiersList) {
                AttributeModifier entityAttributeModifier3 = (AttributeModifier)entityAttributeEntityAttributeModifierPair.getSecond();
                double d = entityAttributeModifier3.m_22218_();
                double e = entityAttributeModifier3.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && entityAttributeModifier3.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? entityAttributeModifier3.m_22218_() : entityAttributeModifier3.m_22218_() * 100.0;
                if (d > 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + entityAttributeModifier3.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(e), Component.m_237115_((String)((Attribute)entityAttributeEntityAttributeModifierPair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d < 0.0)) continue;
                tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + entityAttributeModifier3.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(e *= -1.0), Component.m_237115_((String)((Attribute)entityAttributeEntityAttributeModifierPair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static List<MobEffectInstance> getStewEffects(ItemStack stew) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        CompoundTag compoundTag = stew.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_("Effects", 9)) {
            ListTag listtag = compoundTag.m_128437_("Effects", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag effectTag = listtag.m_128728_(i);
                int duration = 160;
                if (effectTag.m_128425_("EffectDuration", 3)) {
                    duration = effectTag.m_128451_("EffectDuration");
                }
                MobEffect mobeffect = MobEffect.m_19453_((int)effectTag.m_128445_("EffectId"));
                if ((mobeffect = ForgeHooks.loadMobEffect((CompoundTag)effectTag, (String)"forge:effect_id", (MobEffect)mobeffect)) == null) continue;
                effects.add(new MobEffectInstance(mobeffect, duration));
            }
        }
        return effects;
    }
}

